/*
 * Copyright 2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.cache.internal;

import org.gradle.cache.CacheBuilder;
import org.gradle.cache.FineGrainedCacheBuilder;
import org.gradle.cache.UnscopedCacheBuilderFactory;

import java.io.File;

public class DefaultUnscopedCacheBuilderFactory implements UnscopedCacheBuilderFactory {
    private final CacheFactory factory;

    public DefaultUnscopedCacheBuilderFactory(CacheFactory factory) {
        this.factory = factory;
    }

    @Override
    public CacheBuilder cache(File baseDir) {
        return new DefaultCacheBuilder(factory, baseDir);
    }

    @Override
    public FineGrainedCacheBuilder fineGrainedCache(File baseDir) {
        return new DefaultFineGrainedCacheBuilder(factory, baseDir);
    }
}
