plugins {
    id("gradlebuild.distribution.api-java")
}

description = "Implementation for interacting with HTTP build caches"

dependencies {
    api(projects.stdlibJavaExtensions)
    api(projects.serviceProvider)

    api(libs.inject)
    api(libs.jspecify)

    api(projects.baseServices)
    api(projects.buildCacheSpi)
    api(projects.coreApi)
    api(projects.resourcesHttp)

    implementation(projects.core)
    implementation(projects.logging)
    implementation(projects.resources)

    implementation(libs.commonsHttpclient)
    implementation(libs.guava)
    implementation(libs.httpcore)
    implementation(libs.slf4jApi)

    testImplementation(testFixtures(projects.core))
    testImplementation(testLibs.servletApi)

    integTestImplementation(projects.enterpriseOperations)
    integTestImplementation(testFixtures(projects.buildCache))
    integTestImplementation(testLibs.jetty)

    integTestDistributionRuntimeOnly(projects.distributionsJvm) {
        because("Uses application plugin.")
    }
}
tasks.isolatedProjectsIntegTest {
    enabled = false
}
