plugins {
    id("gradlebuild.distribution.implementation-kotlin")
}

description = "Kotlin DSL Provider Plugins"

dependencies {
    api(projects.classloaders)
    api(projects.core)
    api(projects.coreApi)
    api(projects.kotlinDsl)
    api(projects.logging)
    api(projects.serviceProvider)
    api(projects.stdlibJavaExtensions)
    api(projects.persistentCache)
    api(projects.declarativeDslToolingModels)
    api(projects.projectFeatures)

    api(libs.inject)
    api(libs.kotlinStdlib)

    implementation(projects.baseServices)
    implementation(projects.buildDiscovery)
    implementation(projects.concurrent)
    implementation(projects.functional)
    implementation(projects.fileCollections)
    implementation(projects.hashing)
    implementation(projects.loggingApi)
    implementation(projects.pluginDevelopment)
    implementation(projects.platformJvm)
    implementation(projects.projectFeaturesApi)
    implementation(projects.resources)
    implementation(projects.serviceLookup)
    implementation(projects.toolingApi)
    implementation(projects.declarativeDslEvaluator)
    implementation(projects.declarativeDslProvider)
    implementation(projects.declarativeDslCore)

    implementation(libs.kotlinCompilerEmbeddable)

    compileOnly(libs.kotlinReflect)

    testImplementation(testFixtures(projects.kotlinDsl))
    testImplementation(testLibs.mockitoKotlin)
}

packageCycles {
    excludePatterns.add("org/gradle/kotlin/dsl/provider/plugins/precompiled/tasks/**")
}

// Kotlin DSL provider plugins should not be part of the public API
// TODO Find a way to not register this and the task instead
configurations.remove(configurations.apiStubElements.get())
