/*
 * Copyright 2026 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.internal.declarativedsl.schemaBuilder

import org.gradle.declarative.dsl.schema.AnalysisSchema

interface SchemaFailureReporter {
    fun report(partialSchema: AnalysisSchema, failures: List<SchemaResult.Failure>)
}

object ThrowingSchemaFailureReporter : SchemaFailureReporter {
    override fun report(partialSchema: AnalysisSchema, failures: List<SchemaResult.Failure>) {
        if (failures.isNotEmpty()) {
            throw DeclarativeDslSchemaBuildingException(
                if (failures.size == 1) {
                    SchemaFailureMessageFormatter.failureMessage(failures.single())
                } else {
                    failures.joinToString("\n\n", prefix = "Multiple failures in building the declarative schema:\n\n") { failure ->
                        "* " + SchemaFailureMessageFormatter.failureMessage(failure)
                    }
                }
            )
        }
    }
}
