/*
 * Copyright 2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import gradlebuild.basics.testing.TestType
import gradlebuild.basics.testing.includeSpockAnnotation
import gradlebuild.integrationtests.addDependenciesAndConfigurations
import gradlebuild.integrationtests.configureIde
import gradlebuild.integrationtests.createTasks
import gradlebuild.integrationtests.createTestTask
import gradlebuild.integrationtests.extension.IntegrationTestExtension
import gradlebuild.integrationtests.setSystemPropertiesOfTestJVM

plugins {
    java
    id("gradlebuild.dependency-modules")
    id("gradlebuild.jvm-compile")
}

extensions.create<IntegrationTestExtension>("integTest").apply {
    generateDefaultAutoTestedSamplesTest.convention(true)
    testJvmXmx.convention("512m")
}

val sourceSet = sourceSets.create("${TestType.INTEGRATION.prefix}Test")
jvmCompile {
    addCompilationFrom(sourceSet)
}
addDependenciesAndConfigurations(TestType.INTEGRATION.prefix)
configurations.named("integTestRuntimeClasspath") {
    // The InProcessGradleExecuter and the BuildOperationsFixture currently expect the
    // under-development Gradle distribution to be on the runtime classpath. We should
    // avoid this and instead dynamically load the classpath from `integTest.gradleHomeDir` instead.
    extendsFrom(configurations.named("integTestDistributionRuntimeOnly").get())
}
configurations.named("integTestImplementation") {
    // For historical reasons, the integration tests inherit all the dependencies from the unit tests.
    // The integ test suite is not a superset of the unit test suite, so there is no reason to do this.
    // We should remove this `extendsFrom` and update our dependency declarations accordingly.
    extendsFrom(configurations.testImplementation.get())

    dependencies.apply {
        // Use a provider so we don't lookup the project when we generate accessors
        addLater(provider { dependencyFactory.create(project.project(":internal-integ-testing")) })
    }
}

createTasks(sourceSet, TestType.INTEGRATION)
configureIde(TestType.INTEGRATION)

createTestTask("integMultiVersionTest", "forking", sourceSet, TestType.INTEGRATION) {
    // This test task runs only multi-version tests and is intended to be used in the late pipeline to sweep up versions not previously tested
    includeSpockAnnotation("org.gradle.integtests.fixtures.compatibility.MultiVersionTestCategory")
    (options as JUnitPlatformOptions).includeEngines("spock")
    failOnNoDiscoveredTests.set(false)
    setSystemPropertiesOfTestJVM("all")
}
