/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import org.gradle.api.internal.tasks.compile.CompileSpecToArguments;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.internal.process.ArgCollector;
import org.gradle.internal.process.ArgWriter;

public class CommandLineJavaCompilerArgumentsGenerator
implements CompileSpecToArguments<JavaCompileSpec>,
Serializable {
    public void collectArguments(JavaCompileSpec spec, ArgCollector collector) {
        for (String arg : this.generate(spec)) {
            collector.args(new Object[]{arg});
        }
    }

    public Iterable<String> generate(JavaCompileSpec spec) {
        List launcherOptions = new JavaCompilerArgumentsBuilder(spec).includeLauncherOptions(true).includeMainOptions(false).includeClasspath(false).build();
        List remainingArgs = new JavaCompilerArgumentsBuilder(spec).includeSourceFiles(true).build();
        return Iterables.concat((Iterable)launcherOptions, this.shortenArgs(spec.getTempDir(), remainingArgs));
    }

    private Iterable<String> shortenArgs(File tempDir, List<String> args) {
        return (Iterable)ArgWriter.argsFileGenerator((File)new File(tempDir, "java-compiler-args.txt"), (Function)ArgWriter.unixStyleFactory()).apply(args);
    }
}

