/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.lang.management.ThreadMXBean;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.TotalProfiler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0096\bJ!\u0010\t\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0096\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/daemon/common/WallAndThreadTotalProfiler;", "Lorg/jetbrains/kotlin/daemon/common/TotalProfiler;", "<init>", "()V", "beginMeasure", "", "", "obj", "", "endMeasure", "", "startState", "daemon-common"})
@SourceDebugExtension(value={"SMAP\nPerfUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/WallAndThreadTotalProfiler\n+ 2 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n*L\n1#1,196:1\n107#2,2:197\n83#2:199\n109#2:200\n86#2:201\n110#2:202\n114#2,5:203\n83#2:208\n119#2:209\n86#2:210\n120#2:211\n*S KotlinDebug\n*F\n+ 1 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/WallAndThreadTotalProfiler\n*L\n167#1:197,2\n167#1:199\n167#1:200\n167#1:201\n167#1:202\n169#1:203,5\n169#1:208\n169#1:209\n169#1:210\n169#1:211\n*E\n"})
public final class WallAndThreadTotalProfiler
extends TotalProfiler {
    @Override
    @NotNull
    public List<Long> beginMeasure(@Nullable Object obj) {
        boolean $i$f$beginMeasure = false;
        ThreadMXBean threadMXBean = this.getThreadMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"<get-threadMXBean>(...)");
        ThreadMXBean threadMXBean$iv = threadMXBean;
        boolean $i$f$beginMeasureWallAndThreadTimes = false;
        long startTime$iv = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime$iv = $this$threadCpuTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime$iv = $this$threadUserTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv$iv.getCurrentThreadUserTime() : 0L;
        Object[] objectArray = new Long[]{startTime$iv, startThreadTime$iv, startThreadUserTime$iv};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void endMeasure(@Nullable Object obj, @NotNull List<Long> startState) {
        void perfCounters$iv;
        void threadMXBean$iv;
        Intrinsics.checkNotNullParameter(startState, (String)"startState");
        boolean $i$f$endMeasure = false;
        PerfCounters perfCounters = this.getTotal();
        ThreadMXBean threadMXBean = this.getThreadMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"<get-threadMXBean>(...)");
        ThreadMXBean threadMXBean2 = threadMXBean;
        List<Long> startState$iv = startState;
        boolean $i$f$endMeasureWallAndThreadTimes = false;
        long startTime$iv = ((Number)startState$iv.get(0)).longValue();
        long startThreadTime$iv = ((Number)startState$iv.get(1)).longValue();
        long startThreadUserTime$iv = ((Number)startState$iv.get(2)).longValue();
        void $this$threadCpuTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadCpuTime = false;
        void $this$threadUserTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadUserTime = false;
        PerfCounters.addMeasurement$default((PerfCounters)perfCounters$iv, System.nanoTime() - startTime$iv, ($this$threadCpuTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv$iv.getCurrentThreadCpuTime() : 0L) - startThreadTime$iv, ($this$threadUserTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv$iv.getCurrentThreadUserTime() : 0L) - startThreadUserTime$iv, 0L, 8, null);
    }
}

