/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.ComponentArtifactResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.jspecify.annotations.Nullable;

public abstract class AbstractComponentGraphResolveState<T extends ComponentGraphResolveMetadata>
implements ComponentGraphResolveState,
ComponentArtifactResolveState {
    private final long instanceId;
    private final T graphMetadata;
    private final AttributeDesugaring attributeDesugaring;
    private final ImmutableCapability implicitCapability;
    private final ConcurrentHashMap<Long, ResolvedVariantResult> publicVariants = new ConcurrentHashMap();

    public AbstractComponentGraphResolveState(long instanceId, T graphMetadata, AttributeDesugaring attributeDesugaring) {
        this.instanceId = instanceId;
        this.graphMetadata = graphMetadata;
        this.attributeDesugaring = attributeDesugaring;
        this.implicitCapability = DefaultImmutableCapability.defaultCapabilityForComponent(graphMetadata.getModuleVersionId());
    }

    public String toString() {
        return this.getId().toString();
    }

    @Override
    public long getInstanceId() {
        return this.instanceId;
    }

    @Override
    public ComponentIdentifier getId() {
        return this.graphMetadata.getId();
    }

    public T getMetadata() {
        return this.graphMetadata;
    }

    @Override
    public boolean isAdHoc() {
        return false;
    }

    @Override
    public ComponentArtifactResolveState prepareForArtifactResolution() {
        return this;
    }

    @Override
    public ImmutableCapability getDefaultCapability() {
        return this.implicitCapability;
    }

    @Override
    public List<ResolvedVariantResult> getAllSelectableVariantResults() {
        return this.getCandidatesForGraphVariantSelection().getVariantsForAttributeMatching().stream().flatMap(variant -> variant.prepareForArtifactResolution().getArtifactVariants().stream()).map(artifactSet -> new DefaultResolvedVariantResult(this.getId(), Describables.of((Object)artifactSet.getName()), (AttributeContainer)this.attributeDesugaring.desugar(artifactSet.getAttributes().asImmutable()), this.capabilitiesFor(artifactSet.getCapabilities()), null)).collect(Collectors.toList());
    }

    private ImmutableList<Capability> capabilitiesFor(ImmutableCapabilities capabilities) {
        if (capabilities.asSet().isEmpty()) {
            return ImmutableList.of((Object)DefaultImmutableCapability.defaultCapabilityForComponent(this.getMetadata().getModuleVersionId()));
        }
        return ImmutableList.copyOf(capabilities.asSet());
    }

    @Override
    public ResolvedVariantResult getPublicViewFor(VariantGraphResolveState variant, @Nullable ResolvedVariantResult externalVariant) {
        if (externalVariant != null) {
            return this.createVariantResult(variant, externalVariant);
        }
        return this.publicVariants.computeIfAbsent(variant.getInstanceId(), k -> this.createVariantResult(variant, null));
    }

    private DefaultResolvedVariantResult createVariantResult(VariantGraphResolveState variant, @Nullable ResolvedVariantResult externalVariant) {
        VariantGraphResolveMetadata metadata = variant.getMetadata();
        return new DefaultResolvedVariantResult(this.getId(), Describables.of((Object)metadata.getDisplayName()), (AttributeContainer)this.attributeDesugaring.desugar(metadata.getAttributes()), this.capabilitiesFor(metadata.getCapabilities()), externalVariant);
    }
}

