/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import org.gradle.internal.collect.ArrayCopy;
import org.gradle.internal.collect.Modification;
import org.jspecify.annotations.Nullable;

final class HashCollisionNode {
    final int hash;
    final Object[] content;

    HashCollisionNode(int hash, Object[] content) {
        this.hash = hash;
        this.content = content;
    }

    public int hashCode() {
        throw new IllegalStateException();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HashCollisionNode that = (HashCollisionNode)other;
        if (this.hash != that.hash) {
            return false;
        }
        Object[] content = this.content;
        int length = content.length;
        if (length != that.content.length) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            if (that.contains(content[i], 0)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object key, int payload) {
        return this.indexOf(key, payload) >= 0;
    }

    public <K> int indexOf(K key, int payload) {
        int step = 1 + payload;
        Object[] content = this.content;
        for (int i = content.length - step; i >= 0; i -= step) {
            Object data = content[i];
            if (data != key && !data.equals(key)) continue;
            return i;
        }
        return -1;
    }

    public <K> HashCollisionNode add(K key) {
        return this.contains(key, 0) ? this : new HashCollisionNode(this.hash, ArrayCopy.append(this.content, key));
    }

    public <K> HashCollisionNode put(K key, Object val, Modification modification) {
        int index = this.indexOf(key, 1);
        if (index == -1) {
            return new HashCollisionNode(this.hash, ArrayCopy.append(this.content, key, val));
        }
        int valIndex = index + 1;
        if (Objects.equals(this.content[valIndex], val)) {
            return this;
        }
        modification.kind = Modification.Kind.UPDATE;
        return new HashCollisionNode(this.hash, ArrayCopy.replaceAt(valIndex, this.content, val));
    }

    public <K, V> HashCollisionNode modify(K key, BiFunction<? super K, ? super @Nullable V, ? extends @Nullable V> f, Modification modification) {
        int index = this.indexOf(key, 1);
        if (index == -1) {
            V newVal = f.apply(key, null);
            if (newVal == null) {
                return this;
            }
            return new HashCollisionNode(this.hash, ArrayCopy.append(this.content, key, newVal));
        }
        int valIndex = index + 1;
        Object curVal = this.content[valIndex];
        V newVal = f.apply(key, curVal);
        if (newVal == null) {
            modification.kind = Modification.Kind.REMOVAL;
            return this;
        }
        if (Objects.equals(curVal, newVal)) {
            return this;
        }
        modification.kind = Modification.Kind.UPDATE;
        return new HashCollisionNode(this.hash, ArrayCopy.replaceAt(valIndex, this.content, newVal));
    }

    public HashCollisionNode removeAt(int keyIndex, int payload) {
        return new HashCollisionNode(this.hash, ArrayCopy.removeAt(keyIndex, this.content, 1 + payload));
    }

    public String toString() {
        return Arrays.toString(this.content);
    }
}

