/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.features.internal.binding;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClasses;
import org.gradle.features.binding.BuildModel;
import org.gradle.features.binding.Definition;
import org.gradle.features.binding.TargetTypeInformation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0007J$\u0010\n\u001a\u00020\u00052\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\t2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J$\u0010\u000e\u001a\u00020\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\t2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\tH\u0002J \u0010\u000f\u001a\u00020\u00052\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0007\u00a8\u0006\u0012"}, d2={"Lorg/gradle/features/internal/binding/TargetTypeInformationChecks;", "", "<init>", "()V", "isValidBindingType", "", "expectedTargetDefinitionType", "Lorg/gradle/features/binding/TargetTypeInformation;", "actualTargetDefinitionType", "Ljava/lang/Class;", "isValidBuildModelForDefinition", "buildModel", "Lorg/gradle/features/binding/BuildModel;", "definition", "isValidDefinitionForBuildModel", "isOverlappingBindingType", "targetType", "otherTargetType", "project-features"})
@SourceDebugExtension(value={"SMAP\nTargetTypeInformationChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetTypeInformationChecks.kt\norg/gradle/features/internal/binding/TargetTypeInformationChecks\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class TargetTypeInformationChecks {
    @NotNull
    public static final TargetTypeInformationChecks INSTANCE = new TargetTypeInformationChecks();

    private TargetTypeInformationChecks() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isValidBindingType(@NotNull TargetTypeInformation<?> expectedTargetDefinitionType, @NotNull Class<?> actualTargetDefinitionType) {
        Intrinsics.checkNotNullParameter(expectedTargetDefinitionType, (String)"expectedTargetDefinitionType");
        Intrinsics.checkNotNullParameter(actualTargetDefinitionType, (String)"actualTargetDefinitionType");
        TargetTypeInformation<?> targetTypeInformation = expectedTargetDefinitionType;
        if (!(targetTypeInformation instanceof TargetTypeInformation.DefinitionTargetTypeInformation)) {
            if (!(targetTypeInformation instanceof TargetTypeInformation.BuildModelTargetTypeInformation)) return true;
            if (!Definition.class.isAssignableFrom(actualTargetDefinitionType)) return false;
            Class clazz = ((TargetTypeInformation.BuildModelTargetTypeInformation)expectedTargetDefinitionType).getBuildModelType();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getBuildModelType(...)");
            if (!INSTANCE.isValidBuildModelForDefinition(clazz, actualTargetDefinitionType)) return false;
            return true;
        }
        boolean bl = ((TargetTypeInformation.DefinitionTargetTypeInformation)expectedTargetDefinitionType).getDefinitionType().isAssignableFrom(actualTargetDefinitionType);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidBuildModelForDefinition(Class<? extends BuildModel> buildModel, Class<?> definition) {
        Object v0;
        block1: {
            Iterable iterable = KClasses.getAllSupertypes((KClass)JvmClassMappingKt.getKotlinClass(definition));
            for (Object t : iterable) {
                KType it = (KType)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getClassifier(), (Object)Reflection.getOrCreateKotlinClass(Definition.class))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        KType kType = v0;
        if (kType == null) return false;
        KType it = kType;
        boolean bl = false;
        KTypeProjection kTypeProjection = (KTypeProjection)CollectionsKt.singleOrNull((List)it.getArguments());
        KClassifier kClassifier = kTypeProjection != null && (kTypeProjection = kTypeProjection.getType()) != null ? kTypeProjection.getClassifier() : null;
        if (!(kClassifier instanceof KClass)) return false;
        KClass kClass = (KClass)kClassifier;
        Object object = kClass;
        if (kClass == null) return false;
        Class clazz = JvmClassMappingKt.getJavaClass((KClass)object);
        object = clazz;
        if (clazz == null) return false;
        Object object2 = object;
        boolean bl2 = false;
        Boolean bl3 = buildModel.isAssignableFrom((Class<?>)object2);
        Boolean bl4 = bl3;
        if (bl4 == null) return false;
        boolean bl5 = bl4;
        return bl5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidDefinitionForBuildModel(Class<?> definition, Class<? extends BuildModel> buildModel) {
        Object v0;
        block1: {
            Iterable iterable = KClasses.getAllSupertypes((KClass)JvmClassMappingKt.getKotlinClass(definition));
            for (Object t : iterable) {
                KType it = (KType)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getClassifier(), (Object)Reflection.getOrCreateKotlinClass(Definition.class))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        KType kType = v0;
        if (kType == null) return false;
        KType it = kType;
        boolean bl = false;
        KTypeProjection kTypeProjection = (KTypeProjection)CollectionsKt.singleOrNull((List)it.getArguments());
        KClassifier kClassifier = kTypeProjection != null && (kTypeProjection = kTypeProjection.getType()) != null ? kTypeProjection.getClassifier() : null;
        if (!(kClassifier instanceof KClass)) return false;
        KClass kClass = (KClass)kClassifier;
        Object object = kClass;
        if (kClass == null) return false;
        Class clazz = JvmClassMappingKt.getJavaClass((KClass)object);
        object = clazz;
        if (clazz == null) return false;
        Object it2 = object;
        boolean bl2 = false;
        Boolean bl3 = ((Class)it2).isAssignableFrom(buildModel);
        Boolean bl4 = bl3;
        if (bl4 == null) return false;
        boolean bl5 = bl4;
        return bl5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isOverlappingBindingType(@NotNull TargetTypeInformation<?> targetType, @NotNull TargetTypeInformation<?> otherTargetType) {
        Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(otherTargetType, (String)"otherTargetType");
        if (targetType instanceof TargetTypeInformation.DefinitionTargetTypeInformation && otherTargetType instanceof TargetTypeInformation.DefinitionTargetTypeInformation) {
            if (((TargetTypeInformation.DefinitionTargetTypeInformation)targetType).getDefinitionType().isAssignableFrom(((TargetTypeInformation.DefinitionTargetTypeInformation)otherTargetType).getDefinitionType())) return true;
            if (!((TargetTypeInformation.DefinitionTargetTypeInformation)otherTargetType).getDefinitionType().isAssignableFrom(((TargetTypeInformation.DefinitionTargetTypeInformation)targetType).getDefinitionType())) return false;
            return true;
        }
        if (targetType instanceof TargetTypeInformation.BuildModelTargetTypeInformation && otherTargetType instanceof TargetTypeInformation.BuildModelTargetTypeInformation) {
            if (((TargetTypeInformation.BuildModelTargetTypeInformation)targetType).getBuildModelType().isAssignableFrom(((TargetTypeInformation.BuildModelTargetTypeInformation)otherTargetType).getBuildModelType())) return true;
            if (!((TargetTypeInformation.BuildModelTargetTypeInformation)otherTargetType).getBuildModelType().isAssignableFrom(((TargetTypeInformation.BuildModelTargetTypeInformation)targetType).getBuildModelType())) return false;
            return true;
        }
        if (targetType instanceof TargetTypeInformation.DefinitionTargetTypeInformation && otherTargetType instanceof TargetTypeInformation.BuildModelTargetTypeInformation) {
            Class clazz = ((TargetTypeInformation.BuildModelTargetTypeInformation)otherTargetType).getBuildModelType();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getBuildModelType(...)");
            Class clazz2 = ((TargetTypeInformation.DefinitionTargetTypeInformation)targetType).getDefinitionType();
            Intrinsics.checkNotNullExpressionValue((Object)clazz2, (String)"getDefinitionType(...)");
            if (INSTANCE.isValidBuildModelForDefinition(clazz, clazz2)) return true;
            Class clazz3 = ((TargetTypeInformation.DefinitionTargetTypeInformation)targetType).getDefinitionType();
            Intrinsics.checkNotNullExpressionValue((Object)clazz3, (String)"getDefinitionType(...)");
            Class clazz4 = ((TargetTypeInformation.BuildModelTargetTypeInformation)otherTargetType).getBuildModelType();
            Intrinsics.checkNotNullExpressionValue((Object)clazz4, (String)"getBuildModelType(...)");
            if (!INSTANCE.isValidDefinitionForBuildModel(clazz3, clazz4)) return false;
            return true;
        }
        if (!(targetType instanceof TargetTypeInformation.BuildModelTargetTypeInformation)) return false;
        if (!(otherTargetType instanceof TargetTypeInformation.DefinitionTargetTypeInformation)) return false;
        Class clazz = ((TargetTypeInformation.BuildModelTargetTypeInformation)targetType).getBuildModelType();
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getBuildModelType(...)");
        Class clazz5 = ((TargetTypeInformation.DefinitionTargetTypeInformation)otherTargetType).getDefinitionType();
        Intrinsics.checkNotNullExpressionValue((Object)clazz5, (String)"getDefinitionType(...)");
        if (INSTANCE.isValidBuildModelForDefinition(clazz, clazz5)) return true;
        Class clazz6 = ((TargetTypeInformation.DefinitionTargetTypeInformation)otherTargetType).getDefinitionType();
        Intrinsics.checkNotNullExpressionValue((Object)clazz6, (String)"getDefinitionType(...)");
        Class clazz7 = ((TargetTypeInformation.BuildModelTargetTypeInformation)targetType).getBuildModelType();
        Intrinsics.checkNotNullExpressionValue((Object)clazz7, (String)"getBuildModelType(...)");
        if (!INSTANCE.isValidDefinitionForBuildModel(clazz6, clazz7)) return false;
        return true;
    }
}

