/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.jvm.inspection.JavaInstallationRegistry;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmInstallationProblemReporter;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.jvm.inspection.JvmToolchainMetadata;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.AutoInstalledInstallationSupplier;
import org.gradle.jvm.toolchain.internal.CurrentInstallationSupplier;
import org.gradle.jvm.toolchain.internal.EnvironmentVariableJavaHomeInstallationSupplier;
import org.gradle.jvm.toolchain.internal.EnvironmentVariableListInstallationSupplier;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;
import org.gradle.jvm.toolchain.internal.JdkCacheDirectory;
import org.gradle.jvm.toolchain.internal.LocationListInstallationSupplier;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DefaultJavaInstallationRegistry
implements JavaInstallationRegistry {
    private final @Nullable BuildOperationRunner buildOperationRunner;
    private final Installations installations;
    private final JvmMetadataDetector metadataDetector;
    private final Logger logger;
    private final OperatingSystem os;
    private final @Nullable ProgressLoggerFactory progressLoggerFactory;
    private final JvmInstallationProblemReporter problemReporter;

    @Inject
    public DefaultJavaInstallationRegistry(ToolchainConfiguration toolchainConfiguration, List<InstallationSupplier> suppliers, JvmMetadataDetector metadataDetector, @Nullable BuildOperationRunner buildOperationRunner, OperatingSystem os, @Nullable ProgressLoggerFactory progressLoggerFactory, FileResolver fileResolver, JdkCacheDirectory jdkCacheDirectory, JvmInstallationProblemReporter problemReporter) {
        this(toolchainConfiguration, DefaultJavaInstallationRegistry.builtInSuppliers(toolchainConfiguration, fileResolver, jdkCacheDirectory), suppliers, metadataDetector, Logging.getLogger(JavaInstallationRegistry.class), buildOperationRunner, os, progressLoggerFactory, problemReporter);
    }

    @VisibleForTesting
    protected DefaultJavaInstallationRegistry(ToolchainConfiguration toolchainConfiguration, List<InstallationSupplier> suppliers, List<InstallationSupplier> optionalSuppliers, JvmMetadataDetector metadataDetector, Logger logger, @Nullable BuildOperationRunner buildOperationRunner, OperatingSystem os, @Nullable ProgressLoggerFactory progressLoggerFactory, JvmInstallationProblemReporter problemReporter) {
        this.logger = logger;
        this.buildOperationRunner = buildOperationRunner;
        this.metadataDetector = metadataDetector;
        ArrayList<InstallationSupplier> allSuppliers = new ArrayList<InstallationSupplier>(suppliers);
        if (toolchainConfiguration.isAutoDetectEnabled()) {
            allSuppliers.addAll(optionalSuppliers);
        }
        this.installations = new Installations(() -> this.maybeCollectInBuildOperation(allSuppliers));
        this.os = os;
        this.progressLoggerFactory = progressLoggerFactory;
        this.problemReporter = problemReporter;
    }

    private static List<InstallationSupplier> builtInSuppliers(ToolchainConfiguration toolchainConfiguration, FileResolver fileResolver, JdkCacheDirectory jdkCacheDirectory) {
        ArrayList<InstallationSupplier> allSuppliers = new ArrayList<InstallationSupplier>();
        allSuppliers.add(new EnvironmentVariableListInstallationSupplier(toolchainConfiguration, fileResolver));
        allSuppliers.add(new EnvironmentVariableJavaHomeInstallationSupplier(toolchainConfiguration));
        allSuppliers.add(new LocationListInstallationSupplier(toolchainConfiguration, fileResolver));
        allSuppliers.add(new CurrentInstallationSupplier());
        allSuppliers.add(new AutoInstalledInstallationSupplier(toolchainConfiguration, jdkCacheDirectory));
        return allSuppliers;
    }

    private Set<InstallationLocation> maybeCollectInBuildOperation(List<InstallationSupplier> suppliers) {
        if (this.buildOperationRunner == null) {
            return this.collectInstallations(suppliers);
        }
        return (Set)this.buildOperationRunner.call((CallableBuildOperation)new ToolchainDetectionBuildOperation(() -> this.collectInstallations(suppliers)));
    }

    @VisibleForTesting
    protected Set<InstallationLocation> listInstallations() {
        return this.installations.get();
    }

    @Override
    public List<JvmToolchainMetadata> toolchains() {
        if (this.progressLoggerFactory != null) {
            ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(JavaInstallationRegistry.class).start("Discovering toolchains", "Discovering toolchains");
            List<JvmToolchainMetadata> result = this.listInstallations().parallelStream().peek(location -> progressLogger.progress("Extracting toolchain metadata from " + location.getDisplayName())).map(this::resolveMetadata).collect(Collectors.toList());
            progressLogger.completed();
            return result;
        }
        return this.listInstallations().parallelStream().map(this::resolveMetadata).collect(Collectors.toList());
    }

    private JvmToolchainMetadata resolveMetadata(InstallationLocation location) {
        JvmInstallationMetadata metadata = this.metadataDetector.getMetadata(location);
        return new JvmToolchainMetadata(metadata, location);
    }

    @Override
    public void addInstallation(InstallationLocation installation) {
        this.installations.add(installation);
    }

    private Set<InstallationLocation> collectInstallations(List<InstallationSupplier> suppliers) {
        return suppliers.parallelStream().peek(x -> this.logger.debug("Discovering toolchains provided via {}", (Object)x.getSourceName())).map(Supplier::get).flatMap(Collection::stream).filter(this::installationExists).map(this::canonicalize).map(this::maybeGetEnclosedInstallation).filter(this::installationHasExecutable).filter(DefaultJavaInstallationRegistry.distinctByKey(InstallationLocation::getLocation)).collect(Collectors.toSet());
    }

    protected boolean installationExists(InstallationLocation installationLocation) {
        File file = installationLocation.getLocation();
        if (!file.exists()) {
            this.problemReporter.reportProblemIfNeeded(this.logger, installationLocation, "Directory " + installationLocation.getDisplayName() + " used for java installations does not exist");
            return false;
        }
        if (!file.isDirectory()) {
            this.problemReporter.reportProblemIfNeeded(this.logger, installationLocation, "Path for java installation " + installationLocation.getDisplayName() + " points to a file, not a directory");
            return false;
        }
        return true;
    }

    protected boolean installationHasExecutable(InstallationLocation installationLocation) {
        if (!this.hasJavaExecutable(installationLocation.getLocation())) {
            this.problemReporter.reportProblemIfNeeded(this.logger, installationLocation, "Path for java installation " + installationLocation.getDisplayName() + " does not contain a java executable");
            return false;
        }
        return true;
    }

    private InstallationLocation canonicalize(InstallationLocation location) {
        File file = location.getLocation();
        try {
            File canonicalFile = file.getCanonicalFile();
            File javaHome = this.findJavaHome(canonicalFile);
            return location.withLocation(javaHome);
        }
        catch (IOException e) {
            throw new GradleException(String.format("Could not canonicalize path to java installation: %s.", file), (Throwable)e);
        }
    }

    private InstallationLocation maybeGetEnclosedInstallation(InstallationLocation location) {
        File home = location.getLocation();
        File parentPath = home.getParentFile();
        boolean isEmbeddedJre = home.getName().equalsIgnoreCase("jre");
        if (isEmbeddedJre && this.hasJavaExecutable(parentPath)) {
            return location.withLocation(parentPath);
        }
        return location;
    }

    private File findJavaHome(File potentialHome) {
        if (this.os.isMacOsX() && new File(potentialHome, "Contents/Home").exists()) {
            return new File(potentialHome, "Contents/Home");
        }
        File standaloneJre = new File(potentialHome, "jre");
        if (!this.hasJavaExecutable(potentialHome) && this.hasJavaExecutable(standaloneJre)) {
            return standaloneJre;
        }
        return potentialHome;
    }

    private boolean hasJavaExecutable(File potentialHome) {
        return new File(potentialHome, this.os.getExecutableName("bin/java")).exists();
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    private static class Installations {
        private final Supplier<Set<InstallationLocation>> initializer;
        private Set<InstallationLocation> locations = null;

        Installations(Supplier<Set<InstallationLocation>> initializer) {
            this.initializer = initializer;
        }

        synchronized Set<InstallationLocation> get() {
            this.initIfNeeded();
            return this.locations;
        }

        synchronized void add(InstallationLocation location) {
            this.initIfNeeded();
            this.locations.add(location);
        }

        private void initIfNeeded() {
            if (this.locations == null) {
                this.locations = this.initializer.get();
            }
        }
    }

    private static class ToolchainDetectionBuildOperation
    implements CallableBuildOperation<Set<InstallationLocation>> {
        private final Callable<Set<InstallationLocation>> detectionStrategy;

        public ToolchainDetectionBuildOperation(Callable<Set<InstallationLocation>> detectionStrategy) {
            this.detectionStrategy = detectionStrategy;
        }

        public Set<InstallationLocation> call(BuildOperationContext context) throws Exception {
            return this.detectionStrategy.call();
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)"Toolchain detection").progressDisplayName("Detecting local java toolchains");
        }
    }
}

