/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.FineGrainedCacheCleanupStrategy;
import org.gradle.cache.FineGrainedPersistentCache;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.CacheVisitor;
import org.gradle.cache.internal.DefaultFineGrainedPersistentCache;
import org.gradle.cache.internal.DefaultPersistentDirectoryCache;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.cache.internal.filelock.DefaultLockOptions;
import org.gradle.internal.Cast;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.serialize.Serializer;
import org.jspecify.annotations.Nullable;

public class DefaultCacheFactory
implements CacheFactory,
Closeable {
    private final Map<File, DirCacheReference<?>> dirCaches = new HashMap();
    private final FileLockManager lockManager;
    private final ExecutorFactory executorFactory;
    private final Lock lock = new ReentrantLock();

    public DefaultCacheFactory(FileLockManager fileLockManager, ExecutorFactory executorFactory) {
        this.lockManager = fileLockManager;
        this.executorFactory = executorFactory;
    }

    void onOpen(Object cache) {
    }

    void onClose(Object cache) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentCache open(File cacheDir, String displayName, Map<String, ?> properties, LockOptions lockOptions, @Nullable Consumer<? super PersistentCache> initializer, CacheCleanupStrategy cacheCleanupStrategy) throws CacheOpenException {
        this.lock.lock();
        try {
            DirCacheReference<PersistentCache> dirCacheReference = this.openDirCacheReference(PersistentCache.class, cacheDir, properties, lockOptions, () -> this.openPersistentCache(cacheDir, displayName, properties, lockOptions, initializer, cacheCleanupStrategy));
            ReferenceTrackingPersistentCache referenceTrackingPersistentCache = new ReferenceTrackingPersistentCache(dirCacheReference);
            return referenceTrackingPersistentCache;
        }
        finally {
            this.lock.unlock();
        }
    }

    private PersistentCache openPersistentCache(File cacheDir, String displayName, Map<String, ?> properties, LockOptions lockOptions, @Nullable Consumer<? super PersistentCache> initializer, CacheCleanupStrategy cacheCleanupStrategy) {
        DefaultPersistentDirectoryStore cache;
        if (!properties.isEmpty() || initializer != null) {
            Consumer<? super PersistentCache> initAction = initializer != null ? initializer : __ -> {};
            cache = new DefaultPersistentDirectoryCache(cacheDir, displayName, properties, lockOptions, initAction, cacheCleanupStrategy, this.lockManager, this.executorFactory);
        } else {
            cache = new DefaultPersistentDirectoryStore(cacheDir, displayName, lockOptions, cacheCleanupStrategy, this.lockManager, this.executorFactory);
        }
        cache.open();
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FineGrainedPersistentCache openFineGrained(File cacheDir, String displayName, FineGrainedCacheCleanupStrategy cacheCleanupStrategy) throws CacheOpenException {
        this.lock.lock();
        try {
            DirCacheReference<FineGrainedPersistentCache> dirCacheReference = this.openDirCacheReference(FineGrainedPersistentCache.class, cacheDir, Collections.emptyMap(), DefaultLockOptions.mode(FileLockManager.LockMode.Exclusive), () -> new DefaultFineGrainedPersistentCache(cacheDir, displayName, this.lockManager, cacheCleanupStrategy));
            ReferenceTrackingFineGrainedCache referenceTrackingFineGrainedCache = new ReferenceTrackingFineGrainedCache(dirCacheReference);
            return referenceTrackingFineGrainedCache;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void visitCaches(CacheVisitor visitor) {
        this.dirCaches.values().stream().map(dirCacheReference -> ((DirCacheReference)dirCacheReference).cache).forEach(x$0 -> visitor.visit((CleanableStore)x$0));
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            CompositeStoppable.stoppable(this.dirCaches.values()).stop();
        }
        finally {
            this.dirCaches.clear();
            this.lock.unlock();
        }
    }

    private <T extends Closeable & CleanableStore> DirCacheReference<T> openDirCacheReference(Class<T> cacheType, File cacheDir, Map<String, ?> properties, LockOptions lockOptions, Supplier<T> cacheFactory) {
        DirCacheReference dirCacheReference = this.dirCaches.get(cacheDir);
        if (dirCacheReference == null) {
            Closeable cache = (Closeable)cacheFactory.get();
            dirCacheReference = new DirCacheReference(this, cache, properties, lockOptions);
            this.dirCaches.put(cacheDir, dirCacheReference);
        } else {
            dirCacheReference.validate(cacheType, cacheDir, properties, lockOptions);
        }
        return (DirCacheReference)Cast.uncheckedCast(dirCacheReference);
    }

    private static class DirCacheReference<T extends Closeable & CleanableStore>
    implements Closeable {
        private final Map<String, ?> properties;
        private final LockOptions lockOptions;
        private final T cache;
        private final Set<T> references = new HashSet<T>();
        final /* synthetic */ DefaultCacheFactory this$0;

        DirCacheReference(T cache, Map<String, ?> properties, LockOptions lockOptions) {
            this.this$0 = var1_1;
            this.cache = cache;
            this.properties = properties;
            this.lockOptions = lockOptions;
            var1_1.onOpen(cache);
        }

        public void addReference(T cache) {
            this.references.add(cache);
        }

        public void release(T cache) {
            this.this$0.lock.lock();
            try {
                if (this.references.remove(cache) && this.references.isEmpty()) {
                    this.close();
                }
            }
            finally {
                this.this$0.lock.unlock();
            }
        }

        public void validate(Class<?> cacheType, File cacheDir, Map<String, ?> properties, LockOptions lockOptions) {
            if (!cacheType.isAssignableFrom(this.cache.getClass())) {
                throw new IllegalStateException(String.format("Cache '%s' is already open as '%s' that is not a subtype of expected '%s'.", cacheDir, this.cache.getClass().getName(), cacheType.getName()));
            }
            if (!lockOptions.equals(this.lockOptions)) {
                throw new IllegalStateException(String.format("Cache '%s' is already open with different lock options.", cacheDir));
            }
            if (!properties.equals(this.properties)) {
                throw new IllegalStateException(String.format("Cache '%s' is already open with different properties.", cacheDir));
            }
        }

        @Override
        public void close() {
            this.this$0.onClose(this.cache);
            this.this$0.dirCaches.values().remove(this);
            this.references.clear();
            CompositeStoppable.stoppable((Object[])new Object[]{this.cache}).stop();
        }
    }

    private static class ReferenceTrackingPersistentCache
    implements PersistentCache {
        private final DirCacheReference<PersistentCache> reference;

        private ReferenceTrackingPersistentCache(DirCacheReference<PersistentCache> reference) {
            this.reference = reference;
            reference.addReference(this);
        }

        public String toString() {
            return ((PersistentCache)((DirCacheReference)this.reference).cache).toString();
        }

        @Override
        public void close() {
            this.reference.release(this);
        }

        @Override
        public String getDisplayName() {
            return ((PersistentCache)((DirCacheReference)this.reference).cache).toString();
        }

        @Override
        public File getBaseDir() {
            return ((PersistentCache)((DirCacheReference)this.reference).cache).getBaseDir();
        }

        @Override
        public Collection<File> getReservedCacheFiles() {
            return ((PersistentCache)((DirCacheReference)this.reference).cache).getReservedCacheFiles();
        }

        @Override
        public <K, V> IndexedCache<K, V> createIndexedCache(IndexedCacheParameters<K, V> parameters) {
            return ((PersistentCache)((DirCacheReference)this.reference).cache).createIndexedCache(parameters);
        }

        @Override
        public <K, V> IndexedCache<K, V> createIndexedCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
            return ((PersistentCache)((DirCacheReference)this.reference).cache).createIndexedCache(name, keyType, valueSerializer);
        }

        @Override
        public <K, V> boolean indexedCacheExists(IndexedCacheParameters<K, V> parameters) {
            return ((PersistentCache)((DirCacheReference)this.reference).cache).indexedCacheExists(parameters);
        }

        @Override
        public <T> T withFileLock(Supplier<? extends T> action) {
            return ((PersistentCache)((DirCacheReference)this.reference).cache).withFileLock(action);
        }

        @Override
        public void withFileLock(Runnable action) {
            ((PersistentCache)((DirCacheReference)this.reference).cache).withFileLock(action);
        }

        @Override
        public <T> T useCache(Supplier<? extends T> action) {
            return ((PersistentCache)((DirCacheReference)this.reference).cache).useCache(action);
        }

        @Override
        public void useCache(Runnable action) {
            ((PersistentCache)((DirCacheReference)this.reference).cache).useCache(action);
        }

        @Override
        public void cleanup() {
            ((PersistentCache)((DirCacheReference)this.reference).cache).cleanup();
        }
    }

    private static class ReferenceTrackingFineGrainedCache
    implements FineGrainedPersistentCache {
        private final DirCacheReference<FineGrainedPersistentCache> reference;

        public ReferenceTrackingFineGrainedCache(DirCacheReference<FineGrainedPersistentCache> reference) {
            this.reference = reference;
            reference.addReference(this);
        }

        @Override
        public FineGrainedPersistentCache open() {
            return ((FineGrainedPersistentCache)((DirCacheReference)this.reference).cache).open();
        }

        @Override
        public <T> T useCache(String key, Supplier<? extends T> action) {
            return ((FineGrainedPersistentCache)((DirCacheReference)this.reference).cache).useCache(key, action);
        }

        @Override
        public void useCache(String key, Runnable action) {
            ((FineGrainedPersistentCache)((DirCacheReference)this.reference).cache).useCache(key, action);
        }

        @Override
        public <T> T withFileLock(String key, Supplier<? extends T> action) {
            return ((FineGrainedPersistentCache)((DirCacheReference)this.reference).cache).withFileLock(key, action);
        }

        @Override
        public void withFileLock(String key, Runnable action) {
            ((FineGrainedPersistentCache)((DirCacheReference)this.reference).cache).withFileLock(key, action);
        }

        @Override
        public File getBaseDir() {
            return ((FineGrainedPersistentCache)((DirCacheReference)this.reference).cache).getBaseDir();
        }

        @Override
        public Collection<File> getReservedCacheFiles() {
            return ((FineGrainedPersistentCache)((DirCacheReference)this.reference).cache).getReservedCacheFiles();
        }

        @Override
        public String getDisplayName() {
            return ((FineGrainedPersistentCache)((DirCacheReference)this.reference).cache).getDisplayName();
        }

        @Override
        public void cleanup() {
            ((FineGrainedPersistentCache)((DirCacheReference)this.reference).cache).cleanup();
        }

        @Override
        public void close() {
            this.reference.release(this);
        }

        public String toString() {
            return ((FineGrainedPersistentCache)((DirCacheReference)this.reference).cache).toString();
        }
    }
}

