/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.function.Function;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.internal.Cast;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.state.ModelObject;
import org.jspecify.annotations.Nullable;

public abstract class ValueState<S> {
    private static final ValueState<Object> FINALIZED_VALUE = new FinalizedValue<Object>();

    public static <S> ValueState<S> newState(PropertyHost host) {
        return new NonFinalizedValue(host);
    }

    public static <S> ValueState<S> newState(PropertyHost host, Function<S, S> copier) {
        return new NonFinalizedValueWithCopier<S>(host, copier);
    }

    public abstract boolean shouldFinalize(Describable var1, @Nullable ModelObject var2);

    public abstract ValueState<S> finalState();

    public abstract void setConvention(S var1);

    public abstract void disallowChanges();

    public abstract boolean isDisallowChanges();

    public abstract void finalizeOnNextGet();

    public abstract void disallowUnsafeRead();

    public abstract S explicitValue(S var1);

    public abstract S explicitValue(S var1, S var2);

    public abstract S applyConvention(S var1, S var2);

    public abstract S implicitValue(S var1);

    public abstract S implicitValue();

    public abstract boolean maybeFinalizeOnRead(Describable var1, @Nullable ModelObject var2, ValueSupplier.ValueConsumer var3);

    public abstract void beforeMutate(Describable var1);

    public abstract ValueSupplier.ValueConsumer forUpstream(ValueSupplier.ValueConsumer var1);

    public boolean isFinalized() {
        return this == FINALIZED_VALUE;
    }

    public abstract boolean isFinalizing();

    public void finalizeOnReadIfNeeded(Describable displayName, @Nullable ModelObject effectiveProducer, ValueSupplier.ValueConsumer consumer, Action<ValueSupplier.ValueConsumer> finalizeNow) {
        if (this.maybeFinalizeOnRead(displayName, effectiveProducer, consumer)) {
            finalizeNow.execute((Object)this.forUpstream(consumer));
        }
    }

    public void disallowChangesAndFinalizeOnNextGet() {
        this.disallowChanges();
        this.finalizeOnNextGet();
    }

    public abstract boolean isExplicit();

    public abstract S convention();

    public abstract S setToConvention();

    public abstract S setToConventionIfUnset(S var1);

    public abstract void markAsUpgradedPropertyValue();

    public abstract boolean isUpgradedPropertyValue();

    public abstract void warnOnUpgradedPropertyValueChanges();

    private static class NonFinalizedValue<S>
    extends ValueState<S> {
        private static final byte EXPLICIT_VALUE = 1;
        private static final byte FINALIZE_ON_NEXT_GET = 2;
        private static final byte DISALLOW_CHANGES = 4;
        private static final byte DISALLOW_UNSAFE_READ = 8;
        private static final byte IS_UPGRADED_PROPERTY_VALUE = 16;
        private static final byte WARN_ON_UPGRADED_PROPERTY_CHANGES = 32;
        private final PropertyHost host;
        private byte flags;
        private S convention;

        public NonFinalizedValue(PropertyHost host) {
            this.host = host;
        }

        @Override
        public boolean shouldFinalize(Describable displayName, @Nullable ModelObject producer) {
            String reason;
            if ((this.flags & 8) != 0 && (reason = this.host.beforeRead(producer)) != null) {
                throw new IllegalStateException(this.cannotFinalizeValueOf(displayName, reason));
            }
            return true;
        }

        @Override
        public ValueState<S> finalState() {
            return (ValueState)Cast.uncheckedCast((Object)FINALIZED_VALUE);
        }

        @Override
        public boolean maybeFinalizeOnRead(Describable displayName, @Nullable ModelObject producer, ValueSupplier.ValueConsumer consumer) {
            String reason;
            if (((this.flags & 8) != 0 || consumer == ValueSupplier.ValueConsumer.DisallowUnsafeRead) && (reason = this.host.beforeRead(producer)) != null) {
                throw new IllegalStateException(this.cannotQueryValueOf(displayName, reason));
            }
            return (this.flags & 2) != 0 || consumer == ValueSupplier.ValueConsumer.DisallowUnsafeRead;
        }

        @Override
        public ValueSupplier.ValueConsumer forUpstream(ValueSupplier.ValueConsumer consumer) {
            if ((this.flags & 8) != 0) {
                return ValueSupplier.ValueConsumer.DisallowUnsafeRead;
            }
            return consumer;
        }

        @Override
        public void beforeMutate(Describable displayName) {
            if ((this.flags & 4) != 0) {
                throw new IllegalStateException(String.format("The value for %s cannot be changed any further.", displayName.getDisplayName()));
            }
            if ((this.flags & 0x20) != 0) {
                String shownDisplayName = displayName.getDisplayName();
                ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)("Changing property value of " + shownDisplayName + " at execution time.")).startingWithGradle11("changing property value of " + shownDisplayName + " at execution time will become an error").undocumented()).nagUser();
            }
        }

        @Override
        public void disallowChanges() {
            this.flags = (byte)(this.flags | 4);
        }

        @Override
        public boolean isDisallowChanges() {
            return (this.flags & 4) != 0;
        }

        @Override
        public void finalizeOnNextGet() {
            this.flags = (byte)(this.flags | 2);
        }

        @Override
        public void disallowUnsafeRead() {
            this.flags = (byte)(this.flags | 0xA);
        }

        @Override
        public boolean isFinalizing() {
            return (this.flags & 2) != 0;
        }

        @Override
        public boolean isExplicit() {
            return (this.flags & 1) != 0;
        }

        @Override
        public S convention() {
            return this.convention;
        }

        @Override
        public S setToConvention() {
            this.flags = (byte)(this.flags | 1);
            return this.shallowCopy(this.convention);
        }

        protected S shallowCopy(S toCopy) {
            return toCopy;
        }

        @Override
        public S setToConventionIfUnset(S value) {
            if ((this.flags & 1) == 0) {
                return this.setToConvention();
            }
            return value;
        }

        @Override
        public void markAsUpgradedPropertyValue() {
            this.flags = (byte)(this.flags | 0x10);
        }

        @Override
        public boolean isUpgradedPropertyValue() {
            return (this.flags & 0x10) != 0;
        }

        @Override
        public void warnOnUpgradedPropertyValueChanges() {
            this.flags = (byte)(this.flags | 0x20);
        }

        @Override
        public S explicitValue(S value) {
            this.flags = (byte)(this.flags | 1);
            return value;
        }

        @Override
        public S explicitValue(S value, S defaultValue) {
            if ((this.flags & 1) == 0) {
                return defaultValue;
            }
            return value;
        }

        @Override
        public S implicitValue() {
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
            return this.shallowCopy(this.convention);
        }

        @Override
        public S implicitValue(S newConvention) {
            this.setConvention(newConvention);
            return this.implicitValue();
        }

        @Override
        public S applyConvention(S value, S convention) {
            this.convention = convention;
            if ((this.flags & 1) == 0) {
                return this.shallowCopy(convention);
            }
            return value;
        }

        @Override
        public void setConvention(S convention) {
            this.convention = convention;
        }

        private String cannotFinalizeValueOf(Describable displayName, String reason) {
            return this.cannot("finalize", displayName, reason);
        }

        private String cannotQueryValueOf(Describable displayName, String reason) {
            return this.cannot("query", displayName, reason);
        }

        private String cannot(String what, Describable displayName, String reason) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Cannot " + what + " the value of ");
            formatter.append((CharSequence)displayName.getDisplayName());
            formatter.append((CharSequence)" because ");
            formatter.append((CharSequence)reason);
            formatter.append((CharSequence)".");
            return formatter.toString();
        }
    }

    private static class NonFinalizedValueWithCopier<S>
    extends NonFinalizedValue<S> {
        private final Function<S, S> copier;

        public NonFinalizedValueWithCopier(PropertyHost host, Function<S, S> copier) {
            super(host);
            this.copier = copier;
        }

        @Override
        protected S shallowCopy(S toCopy) {
            return this.copier.apply(toCopy);
        }
    }

    private static class FinalizedValue<S>
    extends ValueState<S> {
        private FinalizedValue() {
        }

        @Override
        public boolean shouldFinalize(Describable displayName, @Nullable ModelObject producer) {
            return false;
        }

        @Override
        public void disallowChanges() {
        }

        @Override
        public boolean isDisallowChanges() {
            return true;
        }

        @Override
        public void finalizeOnNextGet() {
        }

        @Override
        public void disallowUnsafeRead() {
        }

        @Override
        public boolean maybeFinalizeOnRead(Describable displayName, @Nullable ModelObject producer, ValueSupplier.ValueConsumer consumer) {
            return false;
        }

        @Override
        public void beforeMutate(Describable displayName) {
            throw new IllegalStateException(String.format("The value for %s is final and cannot be changed any further.", displayName.getDisplayName()));
        }

        @Override
        public ValueSupplier.ValueConsumer forUpstream(ValueSupplier.ValueConsumer consumer) {
            throw this.unexpected();
        }

        @Override
        public S explicitValue(S value) {
            throw this.unexpected();
        }

        @Override
        public S explicitValue(S value, S defaultValue) {
            throw this.unexpected();
        }

        @Override
        public S applyConvention(S value, S convention) {
            throw this.unexpected();
        }

        @Override
        public S implicitValue() {
            throw this.unexpected();
        }

        @Override
        public S implicitValue(S defaultValue) {
            throw this.unexpected();
        }

        @Override
        public boolean isFinalizing() {
            return true;
        }

        @Override
        public boolean isExplicit() {
            return true;
        }

        @Override
        public S convention() {
            return null;
        }

        @Override
        public S setToConvention() {
            throw this.unexpected();
        }

        @Override
        public S setToConventionIfUnset(S value) {
            throw this.unexpected();
        }

        @Override
        public void markAsUpgradedPropertyValue() {
        }

        @Override
        public boolean isUpgradedPropertyValue() {
            return false;
        }

        @Override
        public void warnOnUpgradedPropertyValueChanges() {
        }

        @Override
        public ValueState<S> finalState() {
            return this;
        }

        @Override
        public void setConvention(S convention) {
            throw this.unexpected();
        }

        private UnsupportedOperationException unexpected() {
            return new UnsupportedOperationException("Valued object is in an unexpected state.");
        }
    }
}

