/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.meta.PsiMetaData;
import org.jetbrains.kotlin.com.intellij.psi.meta.PsiMetaOwner;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.PsiElementProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.TimeoutUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class PsiUtilCore {
    private static final Logger LOG = Logger.getInstance(PsiUtilCore.class);
    public static final PsiElement NULL_PSI_ELEMENT = new NullPsiElement();
    private static final boolean ourSleepDuringValidityCheck = Registry.is("psi.sleep.in.validity.check");
    public static final PsiFile NULL_PSI_FILE = new NullPsiFile();

    public static PsiElement @NotNull [] toPsiElementArray(@NotNull Collection<? extends PsiElement> collection) {
        if (collection == null) {
            PsiUtilCore.$$$reportNull$$$0(0);
        }
        PsiElement[] psiElementArray = collection.isEmpty() ? PsiElement.EMPTY_ARRAY : collection.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            PsiUtilCore.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    public static Language getNotAnyLanguage(ASTNode node) {
        if (node == null) {
            return Language.ANY;
        }
        Language lang = node.getElementType().getLanguage();
        return lang == Language.ANY ? PsiUtilCore.getNotAnyLanguage(node.getTreeParent()) : lang;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        PsiFile originalFile;
        if (element == null) {
            return null;
        }
        if (element instanceof PsiFileSystemItem) {
            return element.isValid() ? ((PsiFileSystemItem)element).getVirtualFile() : null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null || !containingFile.isValid()) {
            return null;
        }
        VirtualFile file = containingFile.getVirtualFile();
        if (file == null && (originalFile = containingFile.getOriginalFile()) != containingFile && originalFile.isValid()) {
            file = originalFile.getVirtualFile();
        }
        return file;
    }

    public static int compareElementsByPosition(@Nullable PsiElement element1, @Nullable PsiElement element2) {
        if (element1 == null && element2 == null) {
            return 0;
        }
        if (element1 == null) {
            return -1;
        }
        if (element2 == null) {
            return 1;
        }
        if (element1.equals(element2)) {
            return 0;
        }
        PsiFile psiFile1 = element1.getContainingFile();
        PsiFile psiFile2 = element2.getContainingFile();
        if (psiFile1 == null && psiFile2 == null) {
            return 0;
        }
        if (psiFile1 == null) {
            return -1;
        }
        if (psiFile2 == null) {
            return 1;
        }
        if (!psiFile1.equals(psiFile2)) {
            String name1 = psiFile1.getName();
            String name2 = psiFile2.getName();
            return name1.compareToIgnoreCase(name2);
        }
        if (element1 instanceof StubBasedPsiElement && element2 instanceof StubBasedPsiElement) {
            Object stub1 = ((StubBasedPsiElement)element1).getStub();
            Object stub2 = ((StubBasedPsiElement)element2).getStub();
            if (stub1 != null && stub2 != null) {
                return PsiUtilCore.compareStubPositions(stub1, stub2);
            }
        }
        TextRange textRange1 = element1.getTextRange();
        TextRange textRange2 = element2.getTextRange();
        if (textRange1 == null && textRange2 == null) {
            return 0;
        }
        if (textRange1 == null) {
            return -1;
        }
        if (textRange2 == null) {
            return 1;
        }
        return Segment.BY_START_OFFSET_THEN_END_OFFSET.compare(textRange1, textRange2);
    }

    private static int compareStubPositions(StubElement<?> stub1, StubElement<?> stub2) {
        int depth1;
        int depth2 = PsiUtilCore.getStubDepth(stub2);
        int diff = Integer.compare(depth1, depth2);
        for (depth1 = PsiUtilCore.getStubDepth(stub1); depth1 > depth2; --depth1) {
            stub1 = stub1.getParentStub();
        }
        while (depth2 > depth1) {
            stub2 = stub2.getParentStub();
            --depth2;
        }
        int cmp = PsiUtilCore.compareBalancedStubs(stub1, stub2);
        return cmp == 0 ? diff : cmp;
    }

    private static int getStubDepth(StubElement<?> stub) {
        int depth = 0;
        while (stub != null) {
            stub = stub.getParentStub();
            ++depth;
        }
        return depth;
    }

    private static int compareBalancedStubs(StubElement<?> stub1, StubElement<?> stub2) {
        StubElement parent2;
        if (stub1 == stub2) {
            return 0;
        }
        StubElement parent1 = stub1.getParentStub();
        int parentCmp = PsiUtilCore.compareBalancedStubs(parent1, parent2 = stub2.getParentStub());
        if (parentCmp != 0) {
            return parentCmp;
        }
        return Integer.compare(parent1.getChildrenStubs().indexOf(stub1), parent2.getChildrenStubs().indexOf(stub2));
    }

    public static boolean hasErrorElementChild(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtilCore.$$$reportNull$$$0(2);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PsiElement getElementAtOffset(@NotNull PsiFile file, int offset) {
        PsiElement elt;
        if (file == null) {
            PsiUtilCore.$$$reportNull$$$0(3);
        }
        if ((elt = file.findElementAt(offset)) == null && offset > 0) {
            elt = file.findElementAt(offset - 1);
        }
        PsiElement psiElement = elt == null ? file : elt;
        if (psiElement == null) {
            PsiUtilCore.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public static PsiFile getTemplateLanguageFile(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    public static PsiFile @NotNull [] toPsiFileArray(@NotNull Collection<? extends PsiFile> collection) {
        if (collection == null) {
            PsiUtilCore.$$$reportNull$$$0(5);
        }
        if (collection.isEmpty()) {
            if (PsiFile.EMPTY_ARRAY == null) {
                PsiUtilCore.$$$reportNull$$$0(6);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        PsiFile[] psiFileArray = collection.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            PsiUtilCore.$$$reportNull$$$0(7);
        }
        return psiFileArray;
    }

    @NotNull
    public static @Unmodifiable List<PsiFile> toPsiFiles(@NotNull PsiManager psiManager, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (psiManager == null) {
            PsiUtilCore.$$$reportNull$$$0(8);
        }
        if (virtualFiles == null) {
            PsiUtilCore.$$$reportNull$$$0(9);
        }
        List<PsiFile> list = ContainerUtil.mapNotNull(virtualFiles, psiManager::findFile);
        if (list == null) {
            PsiUtilCore.$$$reportNull$$$0(10);
        }
        return list;
    }

    public static String getName(PsiElement element) {
        PsiMetaData data;
        String name2 = null;
        if (element instanceof PsiMetaOwner && (data = ((PsiMetaOwner)((Object)element)).getMetaData()) != null) {
            name2 = data.getName(element);
        }
        if (name2 == null && element instanceof PsiNamedElement) {
            name2 = ((PsiNamedElement)element).getName();
        }
        return name2;
    }

    @NotNull
    public static String getQualifiedNameAfterRename(String qName, @NotNull String newName) {
        if (newName == null) {
            PsiUtilCore.$$$reportNull$$$0(11);
        }
        if (qName == null) {
            String string = newName;
            if (string == null) {
                PsiUtilCore.$$$reportNull$$$0(12);
            }
            return string;
        }
        int index = qName.lastIndexOf(46);
        String string = index < 0 ? newName : qName.substring(0, index + 1) + newName;
        if (string == null) {
            PsiUtilCore.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static Language getDialect(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtilCore.$$$reportNull$$$0(14);
        }
        return PsiUtilCore.narrowLanguage(element.getLanguage(), element.getContainingFile().getLanguage());
    }

    @NotNull
    protected static Language narrowLanguage(@NotNull Language language2, @NotNull Language candidate2) {
        if (language2 == null) {
            PsiUtilCore.$$$reportNull$$$0(15);
        }
        if (candidate2 == null) {
            PsiUtilCore.$$$reportNull$$$0(16);
        }
        Language language3 = candidate2.isKindOf(language2) ? candidate2 : language2;
        if (language3 == null) {
            PsiUtilCore.$$$reportNull$$$0(17);
        }
        return language3;
    }

    public static void ensureValid(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtilCore.$$$reportNull$$$0(18);
        }
        if (!element.isValid()) {
            if (ourSleepDuringValidityCheck) {
                TimeoutUtil.sleep(1L);
                if (element.isValid()) {
                    LOG.error("PSI resurrected: " + element + " of " + element.getClass());
                    return;
                }
            }
            throw PluginException.createByClass(new PsiInvalidElementAccessException(element), element.getClass());
        }
    }

    @Nullable
    public static PsiFileSystemItem findFileSystemItem(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || file == null) {
            return null;
        }
        if (project.isDisposed() || !file.isValid()) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance(project);
        return file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
    }

    @NotNull
    public static PsiFile getPsiFile(@NotNull Project project, @NotNull VirtualFile file) {
        PsiManager psiManager;
        PsiFile psi;
        if (project == null) {
            PsiUtilCore.$$$reportNull$$$0(19);
        }
        if (file == null) {
            PsiUtilCore.$$$reportNull$$$0(20);
        }
        if ((psi = (psiManager = PsiManager.getInstance(project)).findFile(file)) != null) {
            PsiFile psiFile = psi;
            if (psiFile == null) {
                PsiUtilCore.$$$reportNull$$$0(21);
            }
            return psiFile;
        }
        FileType fileType = file.getFileType();
        FileViewProvider viewProvider = psiManager.findViewProvider(file);
        Document document = FileDocumentManager.getInstance().getDocument(file);
        boolean ignored = !(file instanceof LightVirtualFile) && FileTypeRegistry.getInstance().isFileIgnored(file);
        VirtualFile vDir = file.getParent();
        PsiDirectory psiDir = vDir == null ? null : PsiManager.getInstance(project).findDirectory(vDir);
        FileIndexFacade indexFacade = FileIndexFacade.getInstance(project);
        @NonNls StringBuilder sb = new StringBuilder();
        sb.append("valid=").append(file.isValid()).append(" isDirectory=").append(file.isDirectory()).append(" hasDocument=").append(document != null).append(" length=").append(file.getLength());
        sb.append("\nproject=").append(project.getName()).append(" default=").append(project.isDefault()).append(" open=").append(project.isOpen());
        sb.append("\nfileType=").append(fileType.getName()).append("/").append(fileType.getClass().getName());
        sb.append("\nisIgnored=").append(ignored);
        sb.append(" underIgnored=").append(indexFacade.isUnderIgnored(file));
        sb.append(" inLibrary=").append(indexFacade.isInLibrary(file));
        sb.append(" parentDir=").append(vDir == null ? "no-vfs" : (vDir.isDirectory() ? "has-vfs-dir" : "has-vfs-file")).append("/").append(psiDir == null ? "no-psi" : "has-psi");
        sb.append("\nviewProvider=").append(viewProvider == null ? "null" : viewProvider.getClass().getName());
        if (viewProvider != null) {
            List<PsiFile> files2 = viewProvider.getAllFiles();
            sb.append(" language=").append(viewProvider.getBaseLanguage().getID());
            sb.append(" physical=").append(viewProvider.isPhysical());
            sb.append(" rootCount=").append(files2.size());
            for (PsiFile o2 : files2) {
                sb.append("\n  root=").append(o2.getLanguage().getID()).append("/").append(o2.getClass().getName());
            }
        }
        LOG.error("no PSI for file '" + file.getName() + "'", new Attachment(file.getPresentableUrl(), sb.toString()));
        throw new AssertionError();
    }

    @Deprecated
    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psiElement, @NotNull Class<? extends T> elementClass) {
        T parent2;
        PsiFile psiFile;
        PsiFile originalFile;
        if (psiElement == null) {
            PsiUtilCore.$$$reportNull$$$0(22);
        }
        if (elementClass == null) {
            PsiUtilCore.$$$reportNull$$$0(23);
        }
        if ((originalFile = (psiFile = psiElement.getContainingFile()).getOriginalFile()) == psiFile) {
            return psiElement;
        }
        TextRange range = psiElement.getTextRange();
        PsiElement element = originalFile.findElementAt(range.getStartOffset());
        int maxLength = range.getLength();
        T next = parent2 = PsiTreeUtil.getParentOfType(element, elementClass, false);
        while (next != null && next.getTextLength() <= maxLength) {
            parent2 = next;
            next = PsiTreeUtil.getParentOfType(next, elementClass, true);
        }
        return parent2;
    }

    @NotNull
    public static Language findLanguageFromElement(@NotNull PsiElement elt) {
        PsiElement parent2;
        if (elt == null) {
            PsiUtilCore.$$$reportNull$$$0(24);
        }
        if (!(elt instanceof PsiFile) && elt.getFirstChild() == null && (parent2 = elt.getParent()) != null) {
            Language language2 = parent2.getLanguage();
            if (language2 == null) {
                PsiUtilCore.$$$reportNull$$$0(25);
            }
            return language2;
        }
        Language language3 = elt.getLanguage();
        if (language3 == null) {
            PsiUtilCore.$$$reportNull$$$0(26);
        }
        return language3;
    }

    @NotNull
    public static Language getLanguageAtOffset(@NotNull PsiFile file, int offset) {
        PsiElement elt;
        if (file == null) {
            PsiUtilCore.$$$reportNull$$$0(27);
        }
        if ((elt = file.findElementAt(offset)) == null) {
            Language language2 = file.getLanguage();
            if (language2 == null) {
                PsiUtilCore.$$$reportNull$$$0(28);
            }
            return language2;
        }
        if (elt instanceof PsiWhiteSpace) {
            int decremented;
            TextRange textRange = elt.getTextRange();
            if (!textRange.contains(offset)) {
                LOG.error("PSI corrupted: in file " + file + " (" + file.getViewProvider().getVirtualFile() + ") offset=" + offset + " returned element " + elt + " with text range " + textRange);
            }
            if ((decremented = textRange.getStartOffset() - 1) >= 0) {
                return PsiUtilCore.getLanguageAtOffset(file, decremented);
            }
        }
        return PsiUtilCore.findLanguageFromElement(elt);
    }

    @NotNull
    public static Project getProjectInReadAction(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtilCore.$$$reportNull$$$0(29);
        }
        Project project = ReadAction.compute(() -> element.getProject());
        if (project == null) {
            PsiUtilCore.$$$reportNull$$$0(30);
        }
        return project;
    }

    @Contract(value="null -> null;!null -> !null")
    public static IElementType getElementType(@Nullable ASTNode node) {
        return node == null ? null : node.getElementType();
    }

    @Contract(value="null -> null")
    public static IElementType getElementType(@Nullable PsiElement element) {
        return element == null ? null : (element instanceof StubBasedPsiElement ? ((StubBasedPsiElement)element).getElementType() : (element instanceof PsiFile ? ((PsiFile)element).getFileElementType() : PsiUtilCore.getElementType(element.getNode())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore";
                break;
            }
            case 2: 
            case 14: 
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiElementArray";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAtOffset";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiFileArray";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiFiles";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameAfterRename";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowLanguage";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findLanguageFromElement";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageAtOffset";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectInReadAction";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toPsiElementArray";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasErrorElementChild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtOffset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toPsiFileArray";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toPsiFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameAfterRename";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDialect";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "narrowLanguage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findLanguageFromElement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageAtOffset";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getProjectInReadAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class NullPsiElement
    implements PsiElement {
        protected NullPsiElement() {
        }

        @Override
        @NotNull
        public Project getProject() {
            throw this.createException();
        }

        @Override
        @NotNull
        public Language getLanguage() {
            throw this.createException();
        }

        @Override
        public PsiManager getManager() {
            throw this.createException();
        }

        @Override
        public PsiElement @NotNull [] getChildren() {
            throw this.createException();
        }

        @Override
        public PsiElement getParent() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getFirstChild() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getLastChild() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getNextSibling() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getPrevSibling() {
            throw this.createException();
        }

        @Override
        public PsiFile getContainingFile() {
            throw this.createException();
        }

        @Override
        public TextRange getTextRange() {
            throw this.createException();
        }

        @Override
        public int getStartOffsetInParent() {
            throw this.createException();
        }

        @Override
        public int getTextLength() {
            throw this.createException();
        }

        @Override
        public PsiElement findElementAt(int offset) {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiReference findReferenceAt(int offset) {
            throw this.createException();
        }

        @Override
        public int getTextOffset() {
            throw this.createException();
        }

        @Override
        public String getText() {
            throw this.createException();
        }

        @Override
        public char @NotNull [] textToCharArray() {
            throw this.createException();
        }

        @Override
        public PsiElement getNavigationElement() {
            throw this.createException();
        }

        @Override
        public PsiElement getOriginalElement() {
            throw this.createException();
        }

        @Override
        public boolean textMatches(@NotNull CharSequence text) {
            if (text == null) {
                NullPsiElement.$$$reportNull$$$0(0);
            }
            throw this.createException();
        }

        @Override
        public boolean textMatches(@NotNull PsiElement element) {
            if (element == null) {
                NullPsiElement.$$$reportNull$$$0(1);
            }
            throw this.createException();
        }

        @Override
        public boolean textContains(char c2) {
            throw this.createException();
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor2) {
            if (visitor2 == null) {
                NullPsiElement.$$$reportNull$$$0(2);
            }
            throw this.createException();
        }

        @Override
        public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
            if (visitor2 == null) {
                NullPsiElement.$$$reportNull$$$0(3);
            }
            throw this.createException();
        }

        @Override
        public PsiElement copy() {
            throw this.createException();
        }

        @Override
        public PsiElement add(@NotNull PsiElement element) {
            if (element == null) {
                NullPsiElement.$$$reportNull$$$0(4);
            }
            throw this.createException();
        }

        @Override
        public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) {
            if (element == null) {
                NullPsiElement.$$$reportNull$$$0(5);
            }
            throw this.createException();
        }

        @Override
        public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) {
            if (element == null) {
                NullPsiElement.$$$reportNull$$$0(6);
            }
            throw this.createException();
        }

        @Override
        public void checkAdd(@NotNull PsiElement element) {
            if (element == null) {
                NullPsiElement.$$$reportNull$$$0(7);
            }
            throw this.createException();
        }

        @Override
        public PsiElement addRange(PsiElement first, PsiElement last) {
            throw this.createException();
        }

        @Override
        public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) {
            if (first == null) {
                NullPsiElement.$$$reportNull$$$0(8);
            }
            if (last == null) {
                NullPsiElement.$$$reportNull$$$0(9);
            }
            throw this.createException();
        }

        @Override
        public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) {
            throw this.createException();
        }

        @Override
        public void delete() {
            throw this.createException();
        }

        @Override
        public void checkDelete() {
            throw this.createException();
        }

        @Override
        public void deleteChildRange(PsiElement first, PsiElement last) {
            throw this.createException();
        }

        @Override
        public PsiElement replace(@NotNull PsiElement newElement) {
            if (newElement == null) {
                NullPsiElement.$$$reportNull$$$0(10);
            }
            throw this.createException();
        }

        @Override
        public boolean isValid() {
            throw this.createException();
        }

        @Override
        public boolean isWritable() {
            throw this.createException();
        }

        PsiInvalidElementAccessException createException() {
            return new PsiInvalidElementAccessException(this, this.toString(), null);
        }

        @Override
        @Nullable
        public PsiReference getReference() {
            throw this.createException();
        }

        @Override
        public PsiReference @NotNull [] getReferences() {
            throw this.createException();
        }

        @Override
        public <T> T getCopyableUserData(@NotNull Key<T> key) {
            if (key == null) {
                NullPsiElement.$$$reportNull$$$0(11);
            }
            throw this.createException();
        }

        @Override
        public <T> void putCopyableUserData(@NotNull Key<T> key, T value2) {
            if (key == null) {
                NullPsiElement.$$$reportNull$$$0(12);
            }
            throw this.createException();
        }

        @Override
        public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
            if (processor == null) {
                NullPsiElement.$$$reportNull$$$0(13);
            }
            if (state == null) {
                NullPsiElement.$$$reportNull$$$0(14);
            }
            if (place == null) {
                NullPsiElement.$$$reportNull$$$0(15);
            }
            throw this.createException();
        }

        @Override
        public PsiElement getContext() {
            throw this.createException();
        }

        @Override
        public boolean isPhysical() {
            throw this.createException();
        }

        @Override
        @NotNull
        public GlobalSearchScope getResolveScope() {
            throw this.createException();
        }

        @Override
        @NotNull
        public SearchScope getUseScope() {
            throw this.createException();
        }

        @Override
        public ASTNode getNode() {
            throw this.createException();
        }

        @Override
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                NullPsiElement.$$$reportNull$$$0(16);
            }
            throw this.createException();
        }

        @Override
        public <T> void putUserData(@NotNull Key<T> key, T value2) {
            if (key == null) {
                NullPsiElement.$$$reportNull$$$0(17);
            }
            throw this.createException();
        }

        @Override
        public Icon getIcon(int flags) {
            throw this.createException();
        }

        @Override
        public boolean isEquivalentTo(PsiElement another) {
            return this == another;
        }

        @Override
        public String toString() {
            return "NULL_PSI_ELEMENT";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "last";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 11: 
                case 12: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "textMatches";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addBefore";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAfter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkAdd";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRangeBefore";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCopyableUserData";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putCopyableUserData";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDeclarations";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NullPsiFile
    extends NullPsiElement
    implements PsiFile {
        private NullPsiFile() {
        }

        @Override
        public FileASTNode getNode() {
            throw this.createException();
        }

        @Override
        public PsiDirectory getParent() {
            throw this.createException();
        }

        @Override
        public VirtualFile getVirtualFile() {
            throw this.createException();
        }

        @Override
        public PsiDirectory getContainingDirectory() {
            throw this.createException();
        }

        @Override
        public long getModificationStamp() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiFile getOriginalFile() {
            throw this.createException();
        }

        @Override
        @NotNull
        public FileType getFileType() {
            throw this.createException();
        }

        @Override
        public PsiFile @NotNull [] getPsiRoots() {
            throw this.createException();
        }

        @Override
        @NotNull
        public FileViewProvider getViewProvider() {
            throw this.createException();
        }

        @Override
        public void subtreeChanged() {
            throw this.createException();
        }

        @Override
        public boolean isDirectory() {
            throw this.createException();
        }

        @Override
        @NotNull
        public String getName() {
            throw this.createException();
        }

        @Override
        public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
            if (processor == null) {
                NullPsiFile.$$$reportNull$$$0(0);
            }
            throw this.createException();
        }

        @Override
        @Nullable
        public ItemPresentation getPresentation() {
            throw this.createException();
        }

        @Override
        public void navigate(boolean requestFocus) {
            throw this.createException();
        }

        @Override
        public boolean canNavigate() {
            throw this.createException();
        }

        @Override
        public boolean canNavigateToSource() {
            throw this.createException();
        }

        @Override
        public void checkSetName(String name2) throws IncorrectOperationException {
            throw this.createException();
        }

        @Override
        public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
            if (name2 == null) {
                NullPsiFile.$$$reportNull$$$0(1);
            }
            throw this.createException();
        }

        @Override
        public String toString() {
            return "NULL_PSI_FILE";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiFile";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

