/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.features.internal.binding;

import java.util.Objects;
import java.util.Optional;
import org.gradle.features.binding.BuildModel;
import org.gradle.features.binding.DeclaredProjectFeatureBindingBuilder;
import org.gradle.features.binding.Definition;
import org.gradle.features.binding.TargetTypeInformation;
import org.gradle.features.internal.binding.DeclaredProjectFeatureBindingBuilderInternal;
import org.gradle.features.internal.binding.ProjectFeatureApplyActionFactory;
import org.gradle.features.internal.binding.ProjectFeatureBindingDeclaration;
import org.gradle.internal.Cast;
import org.gradle.util.Path;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DefaultDeclaredProjectFeatureBindingBuilder<OwnDefinition extends Definition<OwnBuildModel>, OwnBuildModel extends BuildModel, TargetDefinition>
implements DeclaredProjectFeatureBindingBuilderInternal<OwnDefinition, OwnBuildModel> {
    private final Class<OwnDefinition> dslType;
    private final TargetTypeInformation<?> targetDefinitionType;
    private final Class<OwnBuildModel> buildModelType;
    private final Path path;
    private final ProjectFeatureApplyActionFactory<OwnDefinition, OwnBuildModel, ?> applyActionFactory;
    private @Nullable Class<?> dslImplementationType;
    private @Nullable Class<?> buildModelImplementationType;
    private ProjectFeatureBindingDeclaration.Safety definitionSafety = ProjectFeatureBindingDeclaration.Safety.SAFE;
    private ProjectFeatureBindingDeclaration.Safety applyActionSafety = ProjectFeatureBindingDeclaration.Safety.SAFE;

    public DefaultDeclaredProjectFeatureBindingBuilder(Class<OwnDefinition> definitionType, Class<OwnBuildModel> buildModelType, TargetTypeInformation<?> targetDefinitionType, Path path, ProjectFeatureApplyActionFactory<OwnDefinition, OwnBuildModel, TargetDefinition> applyActionFactory) {
        this.targetDefinitionType = targetDefinitionType;
        this.dslType = definitionType;
        this.buildModelType = buildModelType;
        this.path = path;
        this.applyActionFactory = applyActionFactory;
    }

    private static <OwnDefinition extends Definition<OwnBuildModel>, OwnBuildModel extends BuildModel> ProjectFeatureBindingDeclaration<OwnDefinition, OwnBuildModel> bindingOf(final Class<OwnDefinition> definitionType, final @Nullable Class<? extends OwnDefinition> definitionImplementationType, final ProjectFeatureBindingDeclaration.Safety definitionSafety, final ProjectFeatureBindingDeclaration.Safety applyActionSafety, final Path path, final TargetTypeInformation<?> targetDefinitionType, final Class<OwnBuildModel> buildModelType, final @Nullable Class<? extends OwnBuildModel> buildModelImplementationType, final ProjectFeatureApplyActionFactory<OwnDefinition, OwnBuildModel, ?> projectFeatureApplyActionFactory) {
        return new ProjectFeatureBindingDeclaration<OwnDefinition, OwnBuildModel>(){

            @Override
            public TargetTypeInformation<?> targetDefinitionType() {
                return targetDefinitionType;
            }

            @Override
            public Class<OwnDefinition> getDefinitionType() {
                return definitionType;
            }

            @Override
            public Optional<Class<? extends OwnDefinition>> getDefinitionImplementationType() {
                return Optional.ofNullable(definitionImplementationType);
            }

            @Override
            public ProjectFeatureBindingDeclaration.Safety getDefinitionSafety() {
                return definitionSafety;
            }

            @Override
            public ProjectFeatureBindingDeclaration.Safety getApplyActionSafety() {
                return applyActionSafety;
            }

            @Override
            public ProjectFeatureApplyActionFactory<OwnDefinition, OwnBuildModel, ?> getApplyActionFactory() {
                return projectFeatureApplyActionFactory;
            }

            @Override
            public Class<OwnBuildModel> getBuildModelType() {
                return buildModelType;
            }

            @Override
            public Optional<Class<? extends OwnBuildModel>> getBuildModelImplementationType() {
                return Optional.ofNullable(buildModelImplementationType);
            }

            @Override
            public String getName() {
                return Objects.requireNonNull(path.getName());
            }
        };
    }

    public DeclaredProjectFeatureBindingBuilder<OwnDefinition, OwnBuildModel> withUnsafeDefinitionImplementationType(Class<? extends OwnDefinition> implementationType) {
        this.dslImplementationType = implementationType;
        return this.withUnsafeDefinition();
    }

    public DeclaredProjectFeatureBindingBuilder<OwnDefinition, OwnBuildModel> withBuildModelImplementationType(Class<? extends OwnBuildModel> implementationType) {
        this.buildModelImplementationType = implementationType;
        return this;
    }

    public DeclaredProjectFeatureBindingBuilder<OwnDefinition, OwnBuildModel> withUnsafeDefinition() {
        this.definitionSafety = ProjectFeatureBindingDeclaration.Safety.UNSAFE;
        return this;
    }

    public DeclaredProjectFeatureBindingBuilder<OwnDefinition, OwnBuildModel> withUnsafeApplyAction() {
        this.applyActionSafety = ProjectFeatureBindingDeclaration.Safety.UNSAFE;
        return this;
    }

    @Override
    public ProjectFeatureBindingDeclaration<OwnDefinition, OwnBuildModel> build() {
        if (this.dslImplementationType != null && !this.dslType.isAssignableFrom(this.dslImplementationType)) {
            throw new IllegalArgumentException("Implementation type " + this.dslImplementationType + " is not a subtype of dsl type " + this.dslType);
        }
        if (this.buildModelImplementationType != null && !this.buildModelType.isAssignableFrom(this.buildModelImplementationType)) {
            throw new IllegalArgumentException("Implementation type " + this.buildModelImplementationType + " is not a subtype of build model type " + this.buildModelType);
        }
        return DefaultDeclaredProjectFeatureBindingBuilder.bindingOf(this.dslType, (Class)Cast.uncheckedCast(this.dslImplementationType), this.definitionSafety, this.applyActionSafety, this.path, this.targetDefinitionType, this.buildModelType, (Class)Cast.uncheckedCast(this.buildModelImplementationType), this.applyActionFactory);
    }
}

