/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.result;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.DisplayName;
import org.jspecify.annotations.Nullable;

public class DefaultResolvedVariantResult
implements ResolvedVariantResult {
    private final ComponentIdentifier owner;
    private final DisplayName displayName;
    private final AttributeContainer attributes;
    private final ImmutableList<Capability> capabilities;
    private final ResolvedVariantResult externalVariant;
    private final int hashCode;

    public DefaultResolvedVariantResult(ComponentIdentifier owner, DisplayName displayName, AttributeContainer attributes, ImmutableList<Capability> capabilities, @Nullable ResolvedVariantResult externalVariant) {
        this.owner = owner;
        this.displayName = displayName;
        this.attributes = attributes;
        this.capabilities = capabilities;
        this.externalVariant = externalVariant;
        this.hashCode = this.computeHashCode();
    }

    public ComponentIdentifier getOwner() {
        return this.owner;
    }

    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    public String getDisplayName() {
        return this.displayName.getDisplayName();
    }

    public List<Capability> getCapabilities() {
        return this.capabilities;
    }

    public Optional<ResolvedVariantResult> getExternalVariant() {
        return Optional.ofNullable(this.externalVariant);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultResolvedVariantResult that = (DefaultResolvedVariantResult)o;
        if (!this.owner.equals(that.owner)) {
            return false;
        }
        if (!this.displayName.equals(that.displayName)) {
            return false;
        }
        if (!this.attributes.equals(that.attributes)) {
            return false;
        }
        if (!this.capabilities.equals(that.capabilities)) {
            return false;
        }
        return this.externalVariant == null ? that.externalVariant == null : this.externalVariant.equals(that.externalVariant);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = this.owner.hashCode();
        result = 31 * result + this.displayName.hashCode();
        result = 31 * result + this.attributes.hashCode();
        result = 31 * result + this.capabilities.hashCode();
        if (this.externalVariant != null) {
            result = 31 * this.externalVariant.hashCode();
        }
        return result;
    }

    public String toString() {
        return this.displayName.toString();
    }
}

