/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.gradle.api.JavaVersion;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.SystemClassLoaderSpec;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.util.internal.CollectionUtils;
import org.jspecify.annotations.Nullable;

public class ClassLoaderVisitor {
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private final @Nullable ClassLoader stopAt;

    public ClassLoaderVisitor() {
        this(ClassLoader.getSystemClassLoader() == null ? null : ClassLoader.getSystemClassLoader().getParent());
    }

    public ClassLoaderVisitor(@Nullable ClassLoader stopAt) {
        this.stopAt = stopAt;
    }

    public void visit(ClassLoader classLoader) {
        if (classLoader == this.stopAt) {
            this.visitSpec(SystemClassLoaderSpec.INSTANCE);
            return;
        }
        if (classLoader instanceof ClassLoaderHierarchy) {
            ((ClassLoaderHierarchy)((Object)classLoader)).visit(this);
        } else if (classLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)classLoader).getURLs();
            this.visitOpaqueUrlClassloader(classLoader, urls);
        } else if (classLoader == ClassLoader.getSystemClassLoader()) {
            URL[] urls = ClassLoaderVisitor.extractJava9AppClasspath();
            this.visitOpaqueUrlClassloader(classLoader, urls);
        } else {
            this.visitOpaqueUrlClassloader(classLoader, new URL[0]);
        }
    }

    private void visitOpaqueUrlClassloader(ClassLoader classLoader, URL[] urls) {
        String name = ClassLoaderVisitor.getNameOf(classLoader);
        this.visitSpec(new VisitableURLClassLoader.Spec(name, CollectionUtils.toList((Object[])urls)));
        this.visitClassPath(urls);
        if (classLoader.getParent() != null) {
            this.visitParent(classLoader.getParent());
        }
    }

    private static String getNameOf(ClassLoader classLoader) {
        if (JavaVersion.current().isJava9Compatible()) {
            return classLoader.getName();
        }
        return "unknown-loader";
    }

    private static URL[] extractJava9AppClasspath() {
        String cp = System.getProperty(JAVA_CLASS_PATH);
        String[] elements = cp.split(File.pathSeparator);
        URL[] urls = new URL[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            try {
                URL url;
                urls[i] = url = new File(elements[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException mue) {
                throw UncheckedException.throwAsUncheckedException((Throwable)mue);
            }
        }
        return urls;
    }

    public void visitSpec(ClassLoaderSpec spec) {
    }

    public void visitClassPath(URL[] classPath) {
    }

    public void visitParent(ClassLoader classLoader) {
        this.visit(classLoader);
    }
}

