/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.HashCommon;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntSortedSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.ag;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.p;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.r;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ax;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.t;

public class Int2ObjectLinkedOpenHashMap<V>
extends p<V>
implements Hash,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    protected transient int[] key;
    protected transient V[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    protected transient Int2ObjectSortedMap.FastSortedEntrySet<V> entries;
    protected transient IntSortedSet keys;
    protected transient ObjectCollection<V> values;

    /*
     * WARNING - void declaration
     */
    public Int2ObjectLinkedOpenHashMap(int expected, float f2) {
        void var2_2;
        void var1_1;
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap = this;
        int2ObjectLinkedOpenHashMap.minN = int2ObjectLinkedOpenHashMap.n = HashCommon.arraySize((int)var1_1, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, (float)var2_2);
        this.key = new int[this.n + 1];
        this.value = new Object[this.n + 1];
        this.link = new long[this.n + 1];
    }

    public Int2ObjectLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public void ensureCapacity(int capacity) {
        int n2 = HashCommon.arraySize(capacity, this.f);
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    private V a(int n2) {
        V v2 = this.value[n2];
        this.value[n2] = null;
        --this.size;
        this.f(n2);
        this.c(n2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap = this;
            int2ObjectLinkedOpenHashMap.rehash(int2ObjectLinkedOpenHashMap.n / 2);
        }
        return v2;
    }

    private V a() {
        this.containsNullKey = false;
        V v2 = this.value[this.n];
        this.value[this.n] = null;
        --this.size;
        Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap = this;
        int2ObjectLinkedOpenHashMap.f(int2ObjectLinkedOpenHashMap.n);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap2 = this;
            int2ObjectLinkedOpenHashMap2.rehash(int2ObjectLinkedOpenHashMap2.n / 2);
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends Integer, ? extends V> m2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(m2.size());
        } else {
            Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap = this;
            long l2 = int2ObjectLinkedOpenHashMap.size() + m2.size();
            Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap2 = int2ObjectLinkedOpenHashMap;
            int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / int2ObjectLinkedOpenHashMap2.f))));
            if (n2 > int2ObjectLinkedOpenHashMap2.n) {
                int2ObjectLinkedOpenHashMap2.rehash(n2);
            }
        }
        super.putAll(var1_1);
    }

    private int b(int n2) {
        if (n2 == 0) {
            if (this.containsNullKey) {
                return this.n;
            }
            return -(this.n + 1);
        }
        int[] nArray = this.key;
        int n3 = HashCommon.mix(n2) & this.mask;
        int n4 = this.key[n3];
        if (n4 == 0) {
            return -(n3 + 1);
        }
        if (n2 == n4) {
            return n3;
        }
        do {
            if ((n4 = nArray[n3 = n3 + 1 & this.mask]) != 0) continue;
            return -(n3 + 1);
        } while (n2 != n4);
        return n3;
    }

    private void a(int n2, int n3, V v2) {
        if (n2 == this.n) {
            this.containsNullKey = true;
        }
        this.key[n2] = n3;
        this.value[n2] = v2;
        if (this.size == 0) {
            Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap = this;
            int2ObjectLinkedOpenHashMap.first = int2ObjectLinkedOpenHashMap.last = n2;
            this.link[n2] = -1L;
        } else {
            int n4 = this.last;
            this.link[n4] = this.link[n4] ^ (this.link[this.last] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = n2;
        }
        if (this.size++ >= this.maxFill) {
            Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap = this;
            int2ObjectLinkedOpenHashMap.rehash(HashCommon.arraySize(int2ObjectLinkedOpenHashMap.size + 1, this.f));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(int k2, V v2) {
        void var2_3;
        int n2 = this.b(k2);
        if (n2 < 0) {
            void var1_1;
            this.a(-n2 - 1, (int)var1_1, v2);
            return this.defRetValue;
        }
        V v3 = this.value[n2];
        this.value[n2] = var2_3;
        return v3;
    }

    private void c(int n2) {
        int[] nArray = this.key;
        while (true) {
            int n3;
            int n4 = n2;
            n2 = n4 + 1 & this.mask;
            while (true) {
                if ((n3 = nArray[n2]) == 0) {
                    nArray[n4] = 0;
                    this.value[n4] = null;
                    return;
                }
                int n5 = HashCommon.mix(n3) & this.mask;
                if (n4 > n2 ? n4 >= n5 && n5 > n2 : n4 >= n5 || n5 > n2) break;
                n2 = n2 + 1 & this.mask;
            }
            nArray[n4] = n3;
            this.value[n4] = this.value[n2];
            this.a(n2, n4);
        }
    }

    @Override
    public V remove(int k2) {
        if (k2 == 0) {
            if (this.containsNullKey) {
                return this.a();
            }
            return this.defRetValue;
        }
        int[] nArray = this.key;
        int n2 = HashCommon.mix(k2) & this.mask;
        int n3 = this.key[n2];
        if (n3 == 0) {
            return this.defRetValue;
        }
        if (k2 == n3) {
            return this.a(n2);
        }
        do {
            if ((n3 = nArray[n2 = n2 + 1 & this.mask]) != 0) continue;
            return this.defRetValue;
        } while (k2 != n3);
        return this.a(n2);
    }

    @Override
    public V get(int k2) {
        if (k2 == 0) {
            if (this.containsNullKey) {
                return this.value[this.n];
            }
            return this.defRetValue;
        }
        int[] nArray = this.key;
        int n2 = HashCommon.mix(k2) & this.mask;
        int n3 = this.key[n2];
        if (n3 == 0) {
            return this.defRetValue;
        }
        if (k2 == n3) {
            return this.value[n2];
        }
        do {
            if ((n3 = nArray[n2 = n2 + 1 & this.mask]) != 0) continue;
            return this.defRetValue;
        } while (k2 != n3);
        return this.value[n2];
    }

    @Override
    public boolean containsKey(int k2) {
        if (k2 == 0) {
            return this.containsNullKey;
        }
        int[] nArray = this.key;
        int n2 = HashCommon.mix(k2) & this.mask;
        int n3 = this.key[n2];
        if (n3 == 0) {
            return false;
        }
        if (k2 == n3) {
            return true;
        }
        do {
            if ((n3 = nArray[n2 = n2 + 1 & this.mask]) != 0) continue;
            return false;
        } while (k2 != n3);
        return true;
    }

    @Override
    public boolean containsValue(Object v2) {
        V[] VArray = this.value;
        int[] nArray = this.key;
        if (this.containsNullKey && Objects.equals(VArray[this.n], v2)) {
            return true;
        }
        int n2 = this.n;
        while (n2-- != 0) {
            if (nArray[n2] == 0 || !Objects.equals(VArray[n2], v2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, 0);
        Arrays.fill(this.value, null);
        Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap = this;
        int2ObjectLinkedOpenHashMap.last = -1;
        int2ObjectLinkedOpenHashMap.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private void f(int n2) {
        if (this.size == 0) {
            Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap = this;
            int2ObjectLinkedOpenHashMap.last = -1;
            int2ObjectLinkedOpenHashMap.first = -1;
            return;
        }
        if (this.first == n2) {
            this.first = (int)this.link[n2];
            if (this.first >= 0) {
                int n3 = this.first;
                this.link[n3] = this.link[n3] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == n2) {
            this.last = (int)(this.link[n2] >>> 32);
            if (this.last >= 0) {
                int n4 = this.last;
                this.link[n4] = this.link[n4] | 0xFFFFFFFFL;
            }
            return;
        }
        long l2 = this.link[n2];
        n2 = (int)(l2 >>> 32);
        int n5 = (int)l2;
        int n6 = n2;
        this.link[n6] = this.link[n6] ^ (this.link[n2] ^ l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n7 = n5;
        this.link[n7] = this.link[n7] ^ (this.link[n5] ^ l2 & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    protected final void a(int n2, int n3) {
        if (this.size == 1) {
            Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap = this;
            int2ObjectLinkedOpenHashMap.first = int2ObjectLinkedOpenHashMap.last = n3;
            this.link[n3] = -1L;
            return;
        }
        if (this.first == n2) {
            this.first = n3;
            int n4 = (int)this.link[n2];
            this.link[n4] = this.link[n4] ^ (this.link[(int)this.link[n2]] ^ ((long)n3 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[n3] = this.link[n2];
            return;
        }
        if (this.last == n2) {
            this.last = n3;
            int n5 = (int)(this.link[n2] >>> 32);
            this.link[n5] = this.link[n5] ^ (this.link[(int)(this.link[n2] >>> 32)] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n3] = this.link[n2];
            return;
        }
        long l2 = this.link[n2];
        n2 = (int)(l2 >>> 32);
        int n6 = (int)l2;
        int n7 = n2;
        this.link[n7] = this.link[n7] ^ (this.link[n2] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n8 = n6;
        this.link[n8] = this.link[n8] ^ (this.link[n6] ^ ((long)n3 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[n3] = l2;
    }

    @Override
    public int firstIntKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public int lastIntKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public Int2ObjectSortedMap<V> tailMap(int from2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Int2ObjectSortedMap<V> headMap(int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Int2ObjectSortedMap<V> subMap(int from2, int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntComparator comparator() {
        return null;
    }

    @Override
    public Int2ObjectSortedMap.FastSortedEntrySet<V> int2ObjectEntrySet() {
        if (this.entries == null) {
            this.entries = new f(this, 0);
        }
        return this.entries;
    }

    @Override
    public IntSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new d(this, 0);
        }
        return this.keys;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.r<V>(this){
                private /* synthetic */ Int2ObjectLinkedOpenHashMap a;
                {
                    this.a = int2ObjectLinkedOpenHashMap;
                }

                @Override
                public final ObjectIterator<V> iterator() {
                    return new h(this.a);
                }

                @Override
                public final ObjectSpliterator<V> spliterator() {
                    return ax.a((ObjectIterator)((org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.r)this).iterator(), (long)org.jetbrains.kotlin.it.unimi.dsi.fastutil.h.a(this.a), (int)80);
                }

                @Override
                public final void forEach(Consumer<? super V> consumer) {
                    int n2 = this.a.size;
                    int n3 = this.a.first;
                    while (n2-- != 0) {
                        int n4 = n3;
                        n3 = (int)this.a.link[n4];
                        consumer.accept(this.a.value[n4]);
                    }
                }

                @Override
                public final int size() {
                    return this.a.size;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final boolean contains(Object v2) {
                    void var1_1;
                    return ((AbstractInt2ObjectMap)this.a).containsValue(var1_1);
                }

                @Override
                public final void clear() {
                    this.a.clear();
                }
            };
        }
        return this.values;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newN) {
        void var1_1;
        int[] nArray = this.key;
        V[] VArray = this.value;
        int n2 = newN - 1;
        int[] nArray2 = new int[newN + 1];
        Object[] objectArray = new Object[newN + 1];
        int n3 = this.first;
        int n4 = -1;
        int n5 = -1;
        long[] lArray = this.link;
        long[] lArray2 = new long[newN + 1];
        this.first = -1;
        int n6 = this.size;
        while (n6-- != 0) {
            int n7;
            if (nArray[n3] == 0) {
                n7 = newN;
            } else {
                n7 = HashCommon.mix(nArray[n3]) & n2;
                while (nArray2[n7] != 0) {
                    n7 = n7 + 1 & n2;
                }
            }
            nArray2[n7] = nArray[n3];
            objectArray[n7] = VArray[n3];
            if (n4 != -1) {
                int n8 = n5;
                lArray2[n8] = lArray2[n8] ^ (lArray2[n5] ^ (long)n7 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n9 = n7;
                lArray2[n9] = lArray2[n9] ^ (lArray2[n7] ^ ((long)n5 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                n5 = n7;
            } else {
                n5 = this.first = n7;
                lArray2[n7] = -1L;
            }
            n4 = n3;
            n3 = (int)lArray[n3];
        }
        this.link = lArray2;
        this.last = n5;
        if (n5 != -1) {
            int n10 = n5;
            lArray2[n10] = lArray2[n10] | 0xFFFFFFFFL;
        }
        this.n = var1_1;
        this.mask = n2;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = nArray2;
        this.value = objectArray;
    }

    public Int2ObjectLinkedOpenHashMap<V> clone() {
        Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap;
        try {
            int2ObjectLinkedOpenHashMap = (Int2ObjectLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        int2ObjectLinkedOpenHashMap.keys = null;
        int2ObjectLinkedOpenHashMap.values = null;
        int2ObjectLinkedOpenHashMap.entries = null;
        int2ObjectLinkedOpenHashMap.containsNullKey = this.containsNullKey;
        int2ObjectLinkedOpenHashMap.key = (int[])this.key.clone();
        int2ObjectLinkedOpenHashMap.value = (Object[])this.value.clone();
        int2ObjectLinkedOpenHashMap.link = (long[])this.link.clone();
        return int2ObjectLinkedOpenHashMap;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap = this;
        int n3 = int2ObjectLinkedOpenHashMap.containsNullKey ? int2ObjectLinkedOpenHashMap.size - 1 : int2ObjectLinkedOpenHashMap.size;
        int n4 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == 0) {
                ++n4;
            }
            int n5 = this.key[n4];
            Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap2 = this;
            if (int2ObjectLinkedOpenHashMap2 != int2ObjectLinkedOpenHashMap2.value[n4]) {
                n5 ^= this.value[n4] == null ? 0 : this.value[n4].hashCode();
            }
            n2 += n5;
            ++n4;
        }
        if (this.containsNullKey) {
            n2 += this.value[this.n] == null ? 0 : this.value[this.n].hashCode();
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        int[] nArray = this.key;
        V[] VArray = this.value;
        a a2 = new a(this);
        s2.defaultWriteObject();
        int n2 = this.size;
        while (n2-- != 0) {
            int n3 = a2.b();
            s2.writeInt(nArray[n3]);
            s2.writeObject(VArray[n3]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new int[this.n + 1];
        int[] nArray = this.key;
        this.value = new Object[this.n + 1];
        Object[] objectArray = this.value;
        this.link = new long[this.n + 1];
        long[] lArray = this.link;
        int n2 = -1;
        Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap = this;
        int2ObjectLinkedOpenHashMap.last = -1;
        int2ObjectLinkedOpenHashMap.first = -1;
        int n3 = this.size;
        while (n3-- != 0) {
            int n4;
            int n5 = s2.readInt();
            Object object = s2.readObject();
            if (n5 == 0) {
                n4 = this.n;
                this.containsNullKey = true;
            } else {
                n4 = HashCommon.mix(n5) & this.mask;
                while (nArray[n4] != 0) {
                    n4 = n4 + 1 & this.mask;
                }
            }
            nArray[n4] = n5;
            objectArray[n4] = object;
            if (this.first != -1) {
                int n6 = n2;
                lArray[n6] = lArray[n6] ^ (lArray[n2] ^ (long)n4 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n7 = n4;
                lArray[n7] = lArray[n7] ^ (lArray[n4] ^ ((long)n2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                n2 = n4;
                continue;
            }
            n2 = this.first = n4;
            int n8 = n4;
            lArray[n8] = lArray[n8] | 0xFFFFFFFF00000000L;
        }
        this.last = n2;
        if (n2 != -1) {
            int n9 = n2;
            lArray[n9] = lArray[n9] | 0xFFFFFFFFL;
        }
    }

    private final class f
    extends t<Int2ObjectMap.Entry<V>>
    implements Int2ObjectSortedMap.FastSortedEntrySet<V> {
        private /* synthetic */ Int2ObjectLinkedOpenHashMap a;

        private f(Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap) {
            this.a = int2ObjectLinkedOpenHashMap;
        }

        @Override
        public final ObjectBidirectionalIterator<Int2ObjectMap.Entry<V>> iterator() {
            return new a(this.a);
        }

        @Override
        public final ObjectSpliterator<Int2ObjectMap.Entry<V>> spliterator() {
            return ax.a((ObjectIterator)((t)this).iterator(), (long)org.jetbrains.kotlin.it.unimi.dsi.fastutil.h.a(this.a), (int)81);
        }

        @Override
        public final Comparator<? super Int2ObjectMap.Entry<V>> comparator() {
            return null;
        }

        @Override
        public final boolean contains(Object o2) {
            Map.Entry entry;
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if ((entry = (Map.Entry)entry).getKey() == null || !(entry.getKey() instanceof Integer)) {
                return false;
            }
            int n2 = (Integer)entry.getKey();
            entry = entry.getValue();
            if (n2 == 0) {
                return this.a.containsNullKey && Objects.equals(this.a.value[this.a.n], entry);
            }
            int[] nArray = this.a.key;
            int n3 = HashCommon.mix(n2) & this.a.mask;
            int n4 = this.a.key[n3];
            if (n4 == 0) {
                return false;
            }
            if (n2 == n4) {
                return Objects.equals(this.a.value[n3], entry);
            }
            do {
                if ((n4 = nArray[n3 = n3 + 1 & this.a.mask]) != 0) continue;
                return false;
            } while (n2 != n4);
            return Objects.equals(this.a.value[n3], entry);
        }

        @Override
        public final boolean remove(Object o2) {
            Map.Entry entry;
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if ((entry = (Map.Entry)entry).getKey() == null || !(entry.getKey() instanceof Integer)) {
                return false;
            }
            int n2 = (Integer)entry.getKey();
            entry = entry.getValue();
            if (n2 == 0) {
                if (this.a.containsNullKey && Objects.equals(this.a.value[this.a.n], entry)) {
                    this.a.a();
                    return true;
                }
                return false;
            }
            int[] nArray = this.a.key;
            int n3 = HashCommon.mix(n2) & this.a.mask;
            int n4 = this.a.key[n3];
            if (n4 == 0) {
                return false;
            }
            if (n4 == n2) {
                if (Objects.equals(this.a.value[n3], entry)) {
                    this.a.a(n3);
                    return true;
                }
                return false;
            }
            do {
                if ((n4 = nArray[n3 = n3 + 1 & this.a.mask]) != 0) continue;
                return false;
            } while (n4 != n2 || !Objects.equals(this.a.value[n3], entry));
            this.a.a(n3);
            return true;
        }

        @Override
        public final int size() {
            return this.a.size;
        }

        @Override
        public final void clear() {
            this.a.clear();
        }

        private ObjectListIterator<Int2ObjectMap.Entry<V>> b() {
            return new b(this.a);
        }

        @Override
        public final void forEach(Consumer<? super Int2ObjectMap.Entry<V>> consumer) {
            int n2 = this.a.size;
            int n3 = this.a.first;
            while (n2-- != 0) {
                int n4 = n3;
                n3 = (int)this.a.link[n4];
                consumer.accept(new e(this.a, n4));
            }
        }

        @Override
        public final void fastForEach(Consumer<? super Int2ObjectMap.Entry<V>> consumer) {
            e e2 = new e(this.a);
            int n2 = this.a.size;
            int n3 = this.a.first;
            while (n2-- != 0) {
                e2.a = n3;
                n3 = (int)this.a.link[n3];
                consumer.accept(e2);
            }
        }

        @Override
        public final /* synthetic */ ObjectSortedSet tailSet(Object object) {
            Int2ObjectMap.Entry cfr_ignored_0 = (Int2ObjectMap.Entry)object;
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ ObjectSortedSet headSet(Object object) {
            Int2ObjectMap.Entry cfr_ignored_0 = (Int2ObjectMap.Entry)object;
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ ObjectSortedSet subSet(Object object, Object object2) {
            Int2ObjectMap.Entry cfr_ignored_0 = (Int2ObjectMap.Entry)object;
            Int2ObjectMap.Entry cfr_ignored_1 = (Int2ObjectMap.Entry)object2;
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object last() {
            f f2 = this;
            if (f2.a.size == 0) {
                throw new NoSuchElementException();
            }
            return new e(f2.a, f2.a.last);
        }

        @Override
        public final /* synthetic */ Object first() {
            f f2 = this;
            if (f2.a.size == 0) {
                throw new NoSuchElementException();
            }
            return new e(f2.a, f2.a.first);
        }

        @Override
        public final /* synthetic */ SortedSet tailSet(Object object) {
            Int2ObjectMap.Entry cfr_ignored_0 = (Int2ObjectMap.Entry)object;
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ SortedSet headSet(Object object) {
            Int2ObjectMap.Entry cfr_ignored_0 = (Int2ObjectMap.Entry)object;
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ SortedSet subSet(Object object, Object object2) {
            Int2ObjectMap.Entry cfr_ignored_0 = (Int2ObjectMap.Entry)object;
            Int2ObjectMap.Entry cfr_ignored_1 = (Int2ObjectMap.Entry)object2;
            throw new UnsupportedOperationException();
        }

        public final /* synthetic */ b a() {
            return this.b();
        }

        @Override
        public final /* synthetic */ ObjectIterator fastIterator() {
            return this.b();
        }

        /* synthetic */ f(Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap, byte by) {
            this(int2ObjectLinkedOpenHashMap);
        }
    }

    private final class d
    extends r {
        private /* synthetic */ Int2ObjectLinkedOpenHashMap a;

        private d(Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap) {
            this.a = int2ObjectLinkedOpenHashMap;
        }

        private c a() {
            return new c(this.a);
        }

        @Override
        public final IntSpliterator spliterator() {
            return ag.a((IntIterator)this.a(), org.jetbrains.kotlin.it.unimi.dsi.fastutil.h.a(this.a), 337);
        }

        @Override
        public final void forEach(IntConsumer consumer) {
            int n2 = this.a.size;
            int n3 = this.a.first;
            while (n2-- != 0) {
                int n4 = n3;
                n3 = (int)this.a.link[n4];
                consumer.accept(this.a.key[n4]);
            }
        }

        @Override
        public final int size() {
            return this.a.size;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(int k2) {
            void var1_1;
            return ((AbstractInt2ObjectMap)this.a).containsKey((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(int k2) {
            void var1_1;
            int n2 = this.a.size;
            this.a.remove((int)var1_1);
            return this.a.size != n2;
        }

        @Override
        public final void clear() {
            this.a.clear();
        }

        @Override
        public final int firstInt() {
            if (this.a.size == 0) {
                throw new NoSuchElementException();
            }
            return this.a.key[this.a.first];
        }

        @Override
        public final int lastInt() {
            if (this.a.size == 0) {
                throw new NoSuchElementException();
            }
            return this.a.key[this.a.last];
        }

        @Override
        public final IntComparator comparator() {
            return null;
        }

        @Override
        public final IntSortedSet tailSet(int from2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final IntSortedSet headSet(int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final IntSortedSet subSet(int from2, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ IntBidirectionalIterator iterator() {
            return this.a();
        }

        @Override
        public final /* synthetic */ IntIterator iterator() {
            return this.a();
        }

        @Override
        public final /* synthetic */ Iterator iterator() {
            return this.a();
        }

        /* synthetic */ d(Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap, byte by) {
            this(int2ObjectLinkedOpenHashMap);
        }
    }

    private final class a
    extends g
    implements ObjectListIterator {
        private e a;
        private /* synthetic */ Int2ObjectLinkedOpenHashMap b;

        public a(Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap) {
            this.b = int2ObjectLinkedOpenHashMap;
            super(int2ObjectLinkedOpenHashMap);
        }

        @Override
        public final void remove() {
            super.remove();
            this.a.a = -1;
        }

        final /* synthetic */ void a(Object object, int n2) {
            int n3 = n2;
            Consumer consumer = (Consumer)object;
            object = this;
            consumer.accept(new e(((a)object).b, n3));
        }

        @Override
        public final /* synthetic */ void add(Object object) {
            Int2ObjectMap.Entry cfr_ignored_0 = (Int2ObjectMap.Entry)object;
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ void set(Object object) {
            Int2ObjectMap.Entry cfr_ignored_0 = (Int2ObjectMap.Entry)object;
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            a a2 = this;
            this.a = new e(a2.b, a2.b());
            return this.a;
        }

        @Override
        public final /* synthetic */ Object previous() {
            a a2 = this;
            this.a = new e(a2.b, a2.c());
            return this.a;
        }
    }

    private final class h
    extends g
    implements ObjectListIterator {
        private /* synthetic */ Int2ObjectLinkedOpenHashMap a;

        @Override
        public final V previous() {
            return this.a.value[this.c()];
        }

        public h(Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap) {
            this.a = int2ObjectLinkedOpenHashMap;
            super(int2ObjectLinkedOpenHashMap);
        }

        @Override
        public final V next() {
            return this.a.value[this.b()];
        }

        final /* synthetic */ void a(Object object, int n2) {
            int n3 = n2;
            Consumer consumer = (Consumer)object;
            object = this;
            consumer.accept(((h)object).a.value[n3]);
        }
    }

    private final class c
    extends g
    implements IntListIterator {
        private /* synthetic */ Int2ObjectLinkedOpenHashMap a;

        @Override
        public final int a() {
            return this.a.key[this.c()];
        }

        public c(Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap) {
            this.a = int2ObjectLinkedOpenHashMap;
            super(int2ObjectLinkedOpenHashMap);
        }

        @Override
        public final int nextInt() {
            return this.a.key[this.b()];
        }

        final /* synthetic */ void a(Object object, int n2) {
            int n3 = n2;
            IntConsumer intConsumer = (IntConsumer)object;
            object = this;
            intConsumer.accept(((c)object).a.key[n3]);
        }
    }

    private final class b
    extends g
    implements ObjectListIterator {
        private e a;
        private /* synthetic */ Int2ObjectLinkedOpenHashMap b;

        public b(Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap) {
            this.b = int2ObjectLinkedOpenHashMap;
            super(int2ObjectLinkedOpenHashMap);
            this.a = new e(this.b);
        }

        final /* synthetic */ void a(Object object, int n2) {
            int n3 = n2;
            Consumer consumer = (Consumer)object;
            object = this;
            this.a.a = n3;
            consumer.accept(((b)object).a);
        }

        @Override
        public final /* synthetic */ void add(Object object) {
            Int2ObjectMap.Entry cfr_ignored_0 = (Int2ObjectMap.Entry)object;
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ void set(Object object) {
            Int2ObjectMap.Entry cfr_ignored_0 = (Int2ObjectMap.Entry)object;
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            b b2 = this;
            this.a.a = b2.b();
            return b2.a;
        }

        @Override
        public final /* synthetic */ Object previous() {
            b b2 = this;
            this.a.a = b2.c();
            return b2.a;
        }
    }

    private abstract class g<ConsumerType> {
        private int a = -1;
        private int b = -1;
        private int c = -1;
        private int d = -1;
        private /* synthetic */ Int2ObjectLinkedOpenHashMap e;

        abstract void a(ConsumerType var1, int var2);

        protected g(Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap) {
            this.e = int2ObjectLinkedOpenHashMap;
            this.b = int2ObjectLinkedOpenHashMap.first;
            this.d = 0;
        }

        public boolean hasNext() {
            return this.b != -1;
        }

        public boolean hasPrevious() {
            return this.a != -1;
        }

        private final void a() {
            if (this.d >= 0) {
                return;
            }
            if (this.a == -1) {
                this.d = 0;
                return;
            }
            if (this.b == -1) {
                this.d = this.e.size;
                return;
            }
            int n2 = this.e.first;
            this.d = 1;
            while (n2 != this.a) {
                n2 = (int)this.e.link[n2];
                ++this.d;
            }
        }

        public int nextIndex() {
            this.a();
            return this.d;
        }

        public int previousIndex() {
            this.a();
            return this.d - 1;
        }

        public final int b() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.c = this.b;
            this.b = (int)this.e.link[this.c];
            this.a = this.c;
            if (this.d >= 0) {
                ++this.d;
            }
            return this.c;
        }

        public final int c() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.c = this.a;
            this.a = (int)(this.e.link[this.c] >>> 32);
            this.b = this.c;
            if (this.d >= 0) {
                --this.d;
            }
            return this.c;
        }

        public void forEachRemaining(ConsumerType action) {
            while (this.hasNext()) {
                this.c = this.b;
                this.b = (int)this.e.link[this.c];
                this.a = this.c;
                if (this.d >= 0) {
                    ++this.d;
                }
                this.a(action, this.c);
            }
        }

        public void remove() {
            this.a();
            if (this.c == -1) {
                throw new IllegalStateException();
            }
            if (this.c == this.a) {
                --this.d;
                this.a = (int)(this.e.link[this.c] >>> 32);
            } else {
                this.b = (int)this.e.link[this.c];
            }
            --this.e.size;
            if (this.a == -1) {
                this.e.first = this.b;
            } else {
                int n2 = this.a;
                this.e.link[n2] = this.e.link[n2] ^ (this.e.link[this.a] ^ (long)this.b & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.b == -1) {
                this.e.last = this.a;
            } else {
                int n3 = this.b;
                this.e.link[n3] = this.e.link[n3] ^ (this.e.link[this.b] ^ ((long)this.a & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int n4 = this.c;
            this.c = -1;
            if (n4 == this.e.n) {
                this.e.containsNullKey = false;
                this.e.value[this.e.n] = null;
                return;
            }
            int[] nArray = this.e.key;
            while (true) {
                int n5;
                int n6 = n4;
                n4 = n6 + 1 & this.e.mask;
                while (true) {
                    if ((n5 = nArray[n4]) == 0) {
                        nArray[n6] = 0;
                        this.e.value[n6] = null;
                        return;
                    }
                    int n7 = HashCommon.mix(n5) & this.e.mask;
                    if (n6 > n4 ? n6 >= n7 && n7 > n4 : n6 >= n7 || n7 > n4) break;
                    n4 = n4 + 1 & this.e.mask;
                }
                nArray[n6] = n5;
                this.e.value[n6] = this.e.value[n4];
                if (this.b == n4) {
                    this.b = n6;
                }
                if (this.a == n4) {
                    this.a = n6;
                }
                this.e.a(n4, n6);
            }
        }
    }

    final class e
    implements Int2ObjectMap.Entry<V>,
    Map.Entry<Integer, V> {
        int a;
        private /* synthetic */ Int2ObjectLinkedOpenHashMap b;

        e(Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap, int n2) {
            this.b = int2ObjectLinkedOpenHashMap;
            this.a = n2;
        }

        e(Int2ObjectLinkedOpenHashMap int2ObjectLinkedOpenHashMap) {
            this.b = int2ObjectLinkedOpenHashMap;
        }

        @Override
        public final int getIntKey() {
            return this.b.key[this.a];
        }

        @Override
        public final V getValue() {
            return this.b.value[this.a];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V setValue(V v2) {
            void var1_1;
            Object v3 = this.b.value[this.a];
            this.b.value[this.a] = var1_1;
            return v3;
        }

        @Override
        @Deprecated
        public final Integer getKey() {
            return this.b.key[this.a];
        }

        @Override
        public final boolean equals(Object o2) {
            Map.Entry entry;
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            return this.b.key[this.a] == (Integer)(entry = (Map.Entry)entry).getKey() && Objects.equals(this.b.value[this.a], entry.getValue());
        }

        @Override
        public final int hashCode() {
            return this.b.key[this.a] ^ (this.b.value[this.a] == null ? 0 : this.b.value[this.a].hashCode());
        }

        public final String toString() {
            return this.b.key[this.a] + "=>" + this.b.value[this.a];
        }
    }
}

