/*
 * Copyright 2026 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.features.internal.builders.types


import org.gradle.features.internal.builders.definitions.ProjectTypeDefinitionClassBuilder

/**
 * A {@link ProjectTypePluginClassBuilder} for creating a plugin class that does not expose any project types.
 */
class ProjectPluginThatDoesNotExposeProjectTypesBuilder extends ProjectTypePluginClassBuilder {
    ProjectPluginThatDoesNotExposeProjectTypesBuilder(ProjectTypeDefinitionClassBuilder definition) {
        super(definition)
    }

    @Override
    protected String getClassContent() {
        return """
        package org.gradle.test;

        import org.gradle.api.Plugin;
        import org.gradle.api.Project;

        abstract public class ${projectTypePluginClassName} implements Plugin<Project> {
            @Override
            public void apply(Project target) {

            }
        }
    """
    }
}
