/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.features.internal.binding;

import javax.inject.Inject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.features.binding.BuildModel;
import org.gradle.features.binding.Definition;
import org.gradle.features.binding.ProjectFeatureApplicationContext;
import org.gradle.features.internal.binding.ProjectFeatureApplicator;
import org.gradle.features.internal.binding.ProjectFeatureDeclarations;
import org.gradle.features.internal.binding.ProjectFeatureSupportInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.inspection.DefaultTypeParameterInspection;

public interface ProjectFeatureApplicationContextInternal
extends ProjectFeatureApplicationContext {
    @Inject
    public ProjectFeatureDeclarations getProjectFeatureRegistry();

    @Inject
    public ProjectFeatureApplicator getProjectFeatureApplicator();

    default public <T extends Definition<V>, V extends BuildModel> V getBuildModel(T definition) {
        return (V)((BuildModel)Cast.uncheckedNonnullCast((Object)ProjectFeatureSupportInternal.getContext((DynamicObjectAware)definition).getBuildModel()));
    }

    default public <T extends Definition<V>, V extends BuildModel> V registerBuildModel(T definition, Class<? extends V> implementationType) {
        ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext maybeContext = ProjectFeatureSupportInternal.tryGetContext(definition);
        if (maybeContext != null) {
            throw new IllegalStateException("Definition object '" + definition + "' already has a registered build model '" + maybeContext.getBuildModel() + "'. Registering another build model for it is an error.");
        }
        BuildModel buildModel = (BuildModel)ProjectFeatureSupportInternal.createBuildModelInstance(this.getObjectFactory(), implementationType);
        ProjectFeatureSupportInternal.attachDefinitionContext(definition, buildModel, this.getProjectFeatureApplicator(), this.getProjectFeatureRegistry(), this.getObjectFactory());
        return (V)buildModel;
    }

    default public <T extends Definition<V>, V extends BuildModel> V registerBuildModel(T definition) {
        DefaultTypeParameterInspection inspection = new DefaultTypeParameterInspection(Definition.class, BuildModel.class, BuildModel.None.class);
        Class modelType = inspection.parameterTypeFor(definition.getClass());
        return this.registerBuildModel(definition, modelType);
    }
}

