/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.internal.CollectionUtils;

public class NormalizingScalaCompiler
implements Compiler<ScalaJavaJointCompileSpec> {
    private static final Logger LOGGER = Logging.getLogger(NormalizingScalaCompiler.class);
    private final Compiler<ScalaJavaJointCompileSpec> delegate;

    public NormalizingScalaCompiler(Compiler<ScalaJavaJointCompileSpec> delegate) {
        this.delegate = delegate;
    }

    public WorkResult execute(ScalaJavaJointCompileSpec spec) {
        this.resolveSourceFiles((JavaCompileSpec)spec);
        this.resolveClasspath(spec);
        this.resolveNonStringsInCompilerArgs(spec);
        this.logSourceFiles(spec);
        this.logCompilerArguments(spec);
        return this.delegateAndHandleErrors(spec);
    }

    private void resolveSourceFiles(JavaCompileSpec spec) {
        spec.setSourceFiles((Iterable)ImmutableSet.copyOf((Iterable)spec.getSourceFiles()));
    }

    private void resolveClasspath(ScalaJavaJointCompileSpec spec) {
        ArrayList classPath = Lists.newArrayList((Iterable)spec.getCompileClasspath());
        classPath.add(spec.getDestinationDir());
        spec.setCompileClasspath((List)classPath);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Class path: {}", (Object)spec.getCompileClasspath());
        }
    }

    private void resolveNonStringsInCompilerArgs(ScalaJavaJointCompileSpec spec) {
        spec.getCompileOptions().setCompilerArgs(CollectionUtils.toStringList((Iterable)spec.getCompileOptions().getCompilerArgs()));
    }

    private void logSourceFiles(ScalaJavaJointCompileSpec spec) {
        if (!spec.getScalaCompileOptions().isListFiles()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Source files to be compiled:");
        for (File file : spec.getSourceFiles()) {
            builder.append('\n');
            builder.append(file);
        }
        LOGGER.quiet(builder.toString());
    }

    private void logCompilerArguments(ScalaJavaJointCompileSpec spec) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        List compilerArgs = new JavaCompilerArgumentsBuilder((JavaCompileSpec)spec).includeLauncherOptions(true).includeSourceFiles(true).build();
        String joinedArgs = Joiner.on((char)' ').join((Iterable)compilerArgs);
        LOGGER.debug("Java compiler arguments: {}", (Object)joinedArgs);
    }

    private WorkResult delegateAndHandleErrors(ScalaJavaJointCompileSpec spec) {
        try {
            return this.delegate.execute((CompileSpec)spec);
        }
        catch (CompilationFailedException e) {
            if (spec.getCompileOptions().isFailOnError() && spec.getScalaCompileOptions().isFailOnError()) {
                throw e;
            }
            LOGGER.debug("Ignoring compilation failure.");
            return WorkResults.didWork((boolean)false);
        }
    }
}

