/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.jvm.operations;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.ExecutionPolicy;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.buildtools.api.ProjectId;
import org.jetbrains.kotlin.buildtools.api.internal.BaseOption;
import org.jetbrains.kotlin.buildtools.api.jvm.ClassSnapshotGranularity;
import org.jetbrains.kotlin.buildtools.api.jvm.ClasspathEntrySnapshot;
import org.jetbrains.kotlin.buildtools.api.jvm.operations.JvmClasspathSnapshottingOperation;
import org.jetbrains.kotlin.buildtools.internal.BaseOptionWithDefault;
import org.jetbrains.kotlin.buildtools.internal.BuildOperationImpl;
import org.jetbrains.kotlin.buildtools.internal.ClasspathEntrySnapshotImpl;
import org.jetbrains.kotlin.buildtools.internal.Options;
import org.jetbrains.kotlin.buildtools.internal.UseFromImplModuleRestricted;
import org.jetbrains.kotlin.buildtools.internal.trackers.BuildMetricsReporterAdapterKt;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshotter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u001d\u001eB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0097\u0002\u00a2\u0006\u0002\u0010\u000eJ*\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u0011\u001a\u0002H\u000bH\u0097\u0002\u00a2\u0006\u0002\u0010\u0012J\"\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\"\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u001aH\u0086\u0002\u00a2\u0006\u0002\u0010\u001bJ*\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u001a2\u0006\u0010\u0011\u001a\u0002H\u000bH\u0086\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmClasspathSnapshottingOperationImpl;", "Lorg/jetbrains/kotlin/buildtools/internal/BuildOperationImpl;", "Lorg/jetbrains/kotlin/buildtools/api/jvm/ClasspathEntrySnapshot;", "Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmClasspathSnapshottingOperation;", "classpathEntry", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "options", "Lorg/jetbrains/kotlin/buildtools/internal/Options;", "get", "V", "key", "Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmClasspathSnapshottingOperation$Option;", "(Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmClasspathSnapshottingOperation$Option;)Ljava/lang/Object;", "set", "", "value", "(Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmClasspathSnapshottingOperation$Option;Ljava/lang/Object;)V", "execute", "projectId", "Lorg/jetbrains/kotlin/buildtools/api/ProjectId;", "executionPolicy", "Lorg/jetbrains/kotlin/buildtools/api/ExecutionPolicy;", "logger", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmClasspathSnapshottingOperationImpl$Option;", "(Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmClasspathSnapshottingOperationImpl$Option;)Ljava/lang/Object;", "(Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmClasspathSnapshottingOperationImpl$Option;Ljava/lang/Object;)V", "Option", "Companion", "kotlin-build-tools-impl"})
public final class JvmClasspathSnapshottingOperationImpl
extends BuildOperationImpl<ClasspathEntrySnapshot>
implements JvmClasspathSnapshottingOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path classpathEntry;
    @NotNull
    private final Options options;
    @JvmField
    @NotNull
    public static final Option<ClassSnapshotGranularity> GRANULARITY = new Option<ClassSnapshotGranularity>("GRANULARITY", ClassSnapshotGranularity.CLASS_MEMBER_LEVEL);
    @JvmField
    @NotNull
    public static final Option<Boolean> PARSE_INLINED_LOCAL_CLASSES = new Option<Boolean>("PARSE_INLINED_LOCAL_CLASSES", true);

    public JvmClasspathSnapshottingOperationImpl(@NotNull Path classpathEntry) {
        Intrinsics.checkNotNullParameter((Object)classpathEntry, (String)"classpathEntry");
        this.classpathEntry = classpathEntry;
        this.options = new Options(Reflection.getOrCreateKotlinClass(JvmClasspathSnapshottingOperation.class));
    }

    @Override
    @UseFromImplModuleRestricted
    public <V> V get(@NotNull JvmClasspathSnapshottingOperation.Option<V> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.options.get((BaseOption)key);
    }

    @Override
    @UseFromImplModuleRestricted
    public <V> void set(@NotNull JvmClasspathSnapshottingOperation.Option<V> key, V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.options.set((BaseOption)key, value);
    }

    @Override
    @NotNull
    public ClasspathEntrySnapshot execute(@NotNull ProjectId projectId, @NotNull ExecutionPolicy executionPolicy, @Nullable KotlinLogger logger) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)executionPolicy, (String)"executionPolicy");
        ClassSnapshotGranularity granularity = (ClassSnapshotGranularity)this.options.get("GRANULARITY");
        boolean parseInlinedLocalClasses = (Boolean)this.options.get("PARSE_INLINED_LOCAL_CLASSES");
        File file = this.classpathEntry.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshot origin = ClasspathEntrySnapshotter.INSTANCE.snapshot(file, new ClasspathEntrySnapshotter.Settings(granularity, parseInlinedLocalClasses), BuildMetricsReporterAdapterKt.getMetricsReporter(this));
        return new ClasspathEntrySnapshotImpl(origin);
    }

    @Override
    public final <V> V get(@NotNull Option<V> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.options.get(key);
    }

    @Override
    public final <V> void set(@NotNull Option<V> key, V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.options.set(key, value);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmClasspathSnapshottingOperationImpl$Companion;", "", "<init>", "()V", "GRANULARITY", "Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmClasspathSnapshottingOperationImpl$Option;", "Lorg/jetbrains/kotlin/buildtools/api/jvm/ClassSnapshotGranularity;", "PARSE_INLINED_LOCAL_CLASSES", "", "kotlin-build-tools-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/jvm/operations/JvmClasspathSnapshottingOperationImpl$Option;", "V", "Lorg/jetbrains/kotlin/buildtools/internal/BaseOptionWithDefault;", "id", "", "<init>", "(Ljava/lang/String;)V", "default", "(Ljava/lang/String;Ljava/lang/Object;)V", "kotlin-build-tools-impl"})
    public static final class Option<V>
    extends BaseOptionWithDefault<V> {
        public Option(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            super(id);
        }

        public Option(@NotNull String id, V v) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            super(id, v);
        }
    }
}

