/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.FineGrainedMarkAndSweepCacheCleanupStrategy;
import org.gradle.cache.FineGrainedPersistentCache;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.os.OperatingSystem;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class FineGrainedMarkAndSweepLeastRecentlyUsedCacheCleanup
implements CleanupAction {
    private final FileAccessTimeJournal journal;
    private final Supplier<Long> removeUnusedEntriesOlderThan;

    public FineGrainedMarkAndSweepLeastRecentlyUsedCacheCleanup(FileAccessTimeJournal journal, Supplier<Long> removeUnusedEntriesOlderThan) {
        this.journal = journal;
        this.removeUnusedEntriesOlderThan = removeUnusedEntriesOlderThan;
    }

    @Override
    public void clean(CleanableStore cleanableStore, CleanupProgressMonitor progressMonitor) {
        Preconditions.checkArgument((boolean)(cleanableStore instanceof FineGrainedPersistentCache), (String)"Expected a FineGrainedPersistentCache but got: %s", cleanableStore.getClass());
        FineGrainedPersistentCache cache = (FineGrainedPersistentCache)cleanableStore;
        MarkAndSweepCacheEntrySoftDeleter softDeleter = (MarkAndSweepCacheEntrySoftDeleter)this.getSoftDeleter(cache);
        MarkAndSweepCleanupAction cleanupAction = new MarkAndSweepCleanupAction(cache, this.journal, this.removeUnusedEntriesOlderThan, softDeleter);
        cleanupAction.clean(cleanableStore, progressMonitor);
    }

    public FineGrainedMarkAndSweepCacheCleanupStrategy.FineGrainedCacheEntrySoftDeleter getSoftDeleter(FineGrainedPersistentCache cache) {
        return new MarkAndSweepCacheEntrySoftDeleter(cache);
    }

    private static class MarkAndSweepCacheEntrySoftDeleter
    implements FineGrainedMarkAndSweepCacheCleanupStrategy.FineGrainedCacheEntrySoftDeleter {
        private final File gcDir;

        public MarkAndSweepCacheEntrySoftDeleter(FineGrainedPersistentCache cache) {
            this.gcDir = new File(cache.getBaseDir(), ".internal/gc");
        }

        @Override
        public boolean isSoftDeleted(String key) {
            return this.getSoftDeleteMarker(key).exists();
        }

        @Override
        public void removeSoftDeleteMarker(String key) {
            this.getSoftDeleteMarker(key).delete();
        }

        public void softDelete(String key) {
            this.touch(this.getSoftDeleteMarker(key));
            this.touch(this.getSoftGcFile(key));
        }

        public File getKeyGcDir(String key) {
            return new File(this.gcDir, key);
        }

        public File getGcDir() {
            return this.gcDir;
        }

        private File getSoftDeleteMarker(String key) {
            return new File(this.getKeyGcDir(key), "soft.deleted");
        }

        private File getSoftGcFile(String key) {
            return new File(this.getKeyGcDir(key), "gc.properties");
        }

        private void touch(File file) {
            try {
                FileUtils.touch((File)file);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class MarkAndSweepCleanupAction
    extends LeastRecentlyUsedCacheCleanup {
        private final FineGrainedPersistentCache cache;
        private final MarkAndSweepCacheEntrySoftDeleter softDeleter;
        private final Supplier<Long> removeUnusedEntriesOlderThan;

        public MarkAndSweepCleanupAction(FineGrainedPersistentCache cache, FileAccessTimeJournal journal, Supplier<Long> removeUnusedEntriesOlderThan, MarkAndSweepCacheEntrySoftDeleter softDeleter) {
            super(new SingleDepthFilesFinder(1), journal, removeUnusedEntriesOlderThan);
            this.cache = cache;
            this.softDeleter = softDeleter;
            this.removeUnusedEntriesOlderThan = removeUnusedEntriesOlderThan;
        }

        @Override
        public void clean(CleanableStore cleanableStore, CleanupProgressMonitor progressMonitor) {
            super.clean(cleanableStore, progressMonitor);
            this.cleanupOrphanGcDirsAndFileLocks();
        }

        @Override
        protected boolean doDeletion(File path) {
            String key = this.getPathAsCacheKey(path);
            if (!this.shouldBeSoftDeleted(key) && !this.shouldBeHardDeleted(key)) {
                return false;
            }
            return this.cache.useCache(key, () -> {
                if (this.shouldBeSoftDeleted(key)) {
                    this.softDeleter.softDelete(key);
                    return false;
                }
                if (this.shouldBeHardDeleted(key)) {
                    return this.hardDelete(path, key);
                }
                return false;
            });
        }

        private boolean shouldBeSoftDeleted(String key) {
            if (this.softDeleter.isSoftDeleted(key)) {
                return false;
            }
            long lastSoftDeleteTime = this.softDeleter.getSoftGcFile(key).lastModified();
            return lastSoftDeleteTime < this.removeUnusedEntriesOlderThan.get();
        }

        private boolean shouldBeHardDeleted(String key) {
            return this.softDeleter.isSoftDeleted(key) && Instant.now().toEpochMilli() - this.softDeleter.getSoftDeleteMarker(key).lastModified() >= FineGrainedMarkAndSweepCacheCleanupStrategy.SOFT_DELETION_DURATION.toMillis();
        }

        private boolean hardDelete(File path, String key) {
            FileUtils.deleteQuietly((File)path);
            if (!path.exists()) {
                FileUtils.deleteQuietly((File)this.softDeleter.getKeyGcDir(key));
                FileUtils.deleteQuietly((File)this.getLockFile(key));
                return true;
            }
            return false;
        }

        private void cleanupOrphanGcDirsAndFileLocks() {
            Collection<File> reservedCacheFiles = this.cache.getReservedCacheFiles();
            Set<String> entryKeys = MarkAndSweepCleanupAction.listEntryKeys(this.cache.getBaseDir(), file -> !reservedCacheFiles.contains(file), Function.identity());
            Set<String> locksKeys = MarkAndSweepCleanupAction.listEntryKeys(this.getLocksDir(), file -> file.getName().endsWith(".lock"), name -> name.substring(0, name.lastIndexOf(".lock")));
            Set<String> gcDirsKeys = MarkAndSweepCleanupAction.listEntryKeys(this.softDeleter.getGcDir(), File::isDirectory, Function.identity());
            Sets.SetView orphanKeys = Sets.difference((Set)Sets.union(locksKeys, gcDirsKeys), entryKeys);
            orphanKeys.forEach(this::deleteOrphanKey);
        }

        private void deleteOrphanKey(String key) {
            File baseDir = this.cache.getBaseDir();
            File lockFile = this.getLockFile(key);
            File gcDir = this.softDeleter.getKeyGcDir(key);
            File cacheEntry = new File(baseDir, key);
            if (OperatingSystem.current().isWindows()) {
                if (gcDir.exists()) {
                    this.cache.useCache(key, () -> {
                        if (!cacheEntry.exists()) {
                            FileUtils.deleteQuietly((File)gcDir);
                        }
                    });
                }
                FileUtils.deleteQuietly((File)lockFile);
            } else {
                this.cache.useCache(key, () -> {
                    if (!cacheEntry.exists()) {
                        FileUtils.deleteQuietly((File)gcDir);
                        FileUtils.deleteQuietly((File)lockFile);
                    }
                });
            }
        }

        private static Set<String> listEntryKeys(File root, Predicate<File> filter, Function<String, String> mapper) {
            Set<String> set;
            block9: {
                if (!root.exists()) {
                    return Collections.emptySet();
                }
                Stream<Path> stream = Files.list(root.toPath());
                try {
                    set = stream.map(Path::toFile).filter(filter).map(path -> (String)mapper.apply(path.getName())).collect(Collectors.toSet());
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                stream.close();
            }
            return set;
        }

        private File getLocksDir() {
            return new File(this.cache.getBaseDir(), ".internal/locks");
        }

        private File getLockFile(String key) {
            return new File(this.cache.getBaseDir(), ".internal/locks/" + key + ".lock");
        }

        private String getPathAsCacheKey(File path) {
            Preconditions.checkArgument((boolean)path.getParentFile().equals(this.cache.getBaseDir()), (String)"Expected a path '%s' to be a direct child of cache at '%s'.", (Object)path.getAbsolutePath(), (Object)this.cache.getBaseDir().getAbsolutePath());
            return path.getName();
        }
    }
}

