/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.features.binding;

import org.gradle.api.Incubating;
import org.gradle.features.binding.BuildModel;
import org.gradle.features.binding.Definition;

@Incubating
public interface TargetTypeInformation<T> {
    public String getTargetClassName();

    @Incubating
    public static class BuildModelTargetTypeInformation<T extends BuildModel>
    implements TargetTypeInformation<Definition<T>> {
        private final Class<T> buildModelType;
        private final String targetClassName;

        public BuildModelTargetTypeInformation(Class<T> buildModelType) {
            this.buildModelType = buildModelType;
            this.targetClassName = buildModelType.getName();
        }

        public Class<T> getBuildModelType() {
            return this.buildModelType;
        }

        @Override
        public String getTargetClassName() {
            return this.targetClassName;
        }

        public String toString() {
            return "build model type " + this.buildModelType.getSimpleName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuildModelTargetTypeInformation that = (BuildModelTargetTypeInformation)o;
            return this.buildModelType.equals(that.buildModelType);
        }

        public int hashCode() {
            return this.buildModelType.hashCode();
        }
    }

    @Incubating
    public static class DefinitionTargetTypeInformation<T>
    implements TargetTypeInformation<T> {
        private final Class<T> definitionType;
        private final String targetClassName;

        public DefinitionTargetTypeInformation(Class<T> definitionType) {
            this.definitionType = definitionType;
            this.targetClassName = definitionType.getName();
        }

        public Class<T> getDefinitionType() {
            return this.definitionType;
        }

        @Override
        public String getTargetClassName() {
            return this.targetClassName;
        }

        public String toString() {
            return "definition type " + this.definitionType.getSimpleName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefinitionTargetTypeInformation that = (DefinitionTargetTypeInformation)o;
            return this.definitionType.equals(that.definitionType);
        }

        public int hashCode() {
            return this.definitionType.hashCode();
        }
    }
}

