/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.ResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.interfaces.ResolutionFailure;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class AbstractResolutionFailureDescriber<FAILURE extends ResolutionFailure>
implements ResolutionFailureDescriber<FAILURE> {
    private static final String DEFAULT_MESSAGE_PREFIX = "Review the variant matching algorithm at ";

    @Inject
    protected abstract DocumentationRegistry getDocumentationRegistry();

    protected List<String> buildResolutions(String ... resolutions) {
        return Arrays.asList(resolutions);
    }

    protected String suggestReviewAlgorithm() {
        return DEFAULT_MESSAGE_PREFIX + this.getDocumentationRegistry().getDocumentationFor("variant_attributes", "sec:abm_algorithm") + ".";
    }

    protected String suggestSpecificDocumentation(String prefix, String section) {
        return prefix + this.getDocumentationRegistry().getDocumentationFor("variant_model", section) + ".";
    }

    protected void formatAttributeSection(TreeFormatter formatter, String section, List<String> values) {
        if (!values.isEmpty()) {
            if (values.size() > 1) {
                formatter.node(section + "s");
            } else {
                formatter.node(section);
            }
            formatter.startChildren();
            values.forEach(arg_0 -> ((TreeFormatter)formatter).node(arg_0));
            formatter.endChildren();
        }
    }

    protected void formatAttributeMatchesForAmbiguity(ResolutionCandidateAssessor.AssessedCandidate assessedCandidate, TreeFormatter formatter, AttributeDescriber describer) {
        Map<Attribute, String> compatibleAttrs = assessedCandidate.getCompatibleAttributes().stream().collect(Collectors.toMap(ResolutionCandidateAssessor.AssessedAttribute::getAttribute, ResolutionCandidateAssessor.AssessedAttribute::getProvided, (a, b) -> a));
        List onlyOnProducer = assessedCandidate.getOnlyOnCandidateAttributes().stream().map(assessedAttribute -> "Provides " + describer.describeExtraAttribute(assessedAttribute.getAttribute(), (Object)assessedAttribute.getProvided()) + " but the consumer didn't ask for it").collect(Collectors.toList());
        List onlyOnConsumer = assessedCandidate.getOnlyOnRequestAttributes().stream().map(assessedAttribute -> "Doesn't say anything about " + describer.describeMissingAttribute(assessedAttribute.getAttribute(), (Object)assessedAttribute.getRequested())).collect(Collectors.toList());
        ArrayList<String> other = new ArrayList<String>(onlyOnProducer.size() + onlyOnConsumer.size());
        other.addAll(onlyOnProducer);
        other.addAll(onlyOnConsumer);
        other.sort(String::compareTo);
        if (!compatibleAttrs.isEmpty()) {
            formatter.append((CharSequence)" declares ").append((CharSequence)StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.SuccessHeader, (String)describer.describeAttributeSet(compatibleAttrs)));
        }
        formatter.startChildren();
        this.formatAttributeSection(formatter, "Unmatched attribute", other);
        formatter.endChildren();
    }

    protected void formatAttributeMatchesForIncompatibility(ResolutionCandidateAssessor.AssessedCandidate assessedCandidate, TreeFormatter formatter, AttributeDescriber describer) {
        Map<Attribute, String> compatibleAttrs = assessedCandidate.getCompatibleAttributes().stream().collect(Collectors.toMap(ResolutionCandidateAssessor.AssessedAttribute::getAttribute, ResolutionCandidateAssessor.AssessedAttribute::getProvided, (a, b) -> a));
        Map<Attribute, String> incompatibleAttrs = assessedCandidate.getIncompatibleAttributes().stream().collect(Collectors.toMap(ResolutionCandidateAssessor.AssessedAttribute::getAttribute, ResolutionCandidateAssessor.AssessedAttribute::getProvided, (a, b) -> a));
        Map<Attribute, String> incompatibleConsumerAttrs = assessedCandidate.getIncompatibleAttributes().stream().collect(Collectors.toMap(ResolutionCandidateAssessor.AssessedAttribute::getAttribute, ResolutionCandidateAssessor.AssessedAttribute::getRequested, (a, b) -> a));
        List<String> otherValues = assessedCandidate.getOnlyOnRequestAttributes().stream().map(assessedAttribute -> "Doesn't say anything about " + describer.describeMissingAttribute(assessedAttribute.getAttribute(), (Object)assessedAttribute.getRequested())).sorted().collect(Collectors.toList());
        if (!compatibleAttrs.isEmpty()) {
            formatter.append((CharSequence)" declares ").append((CharSequence)StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.SuccessHeader, (String)describer.describeAttributeSet(compatibleAttrs)));
        }
        formatter.startChildren();
        if (!incompatibleAttrs.isEmpty()) {
            formatter.node("Incompatible because this component declares " + StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.FailureHeader, (String)describer.describeAttributeSet(incompatibleAttrs)) + " and the consumer needed " + StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.FailureHeader, (String)describer.describeAttributeSet(incompatibleConsumerAttrs)));
        }
        this.formatAttributeSection(formatter, "Other compatible attribute", otherValues);
        formatter.endChildren();
    }
}

