/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.Optional;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.plugins.PluginTarget;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.configuration.ConfigurationTargetIdentifier;
import org.gradle.features.annotations.BindsProjectFeature;
import org.gradle.features.annotations.BindsProjectType;
import org.gradle.features.annotations.RegistersProjectFeatures;
import org.gradle.features.internal.binding.ProjectFeatureDeclarations;
import org.gradle.internal.Cast;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ProjectFeatureDeclarationPluginTarget
implements PluginTarget {
    private final PluginTarget delegate;
    private final ProjectFeatureDeclarations projectFeatureDeclarations;
    private final InspectionScheme inspectionScheme;
    private final InternalProblems problems;

    public ProjectFeatureDeclarationPluginTarget(PluginTarget delegate, ProjectFeatureDeclarations projectFeatureDeclarations, InspectionScheme inspectionScheme, InternalProblems problems) {
        this.delegate = delegate;
        this.projectFeatureDeclarations = projectFeatureDeclarations;
        this.inspectionScheme = inspectionScheme;
        this.problems = problems;
    }

    @Override
    public ConfigurationTargetIdentifier getConfigurationTargetIdentifier() {
        return this.delegate.getConfigurationTargetIdentifier();
    }

    @Override
    public void applyImperative(@Nullable String pluginId, Plugin<?> plugin) {
        TypeToken pluginType = TypeToken.of(plugin.getClass());
        TypeMetadata typeMetadata = this.inspectionScheme.getMetadataStore().getTypeMetadata(pluginType.getRawType());
        this.findAndAddProjectFeatures(pluginId, typeMetadata);
        this.delegate.applyImperative(pluginId, plugin);
    }

    @Override
    public void applyRules(@Nullable String pluginId, Class<?> clazz) {
        this.delegate.applyRules(pluginId, clazz);
    }

    @Override
    public void applyImperativeRulesHybrid(@Nullable String pluginId, Plugin<?> plugin, Class<?> declaringClass) {
        this.delegate.applyImperativeRulesHybrid(pluginId, plugin, declaringClass);
    }

    public String toString() {
        return this.delegate.toString();
    }

    private void findAndAddProjectFeatures(@Nullable String pluginId, TypeMetadata typeMetadata) {
        Optional registersProjectFeatures = typeMetadata.getTypeAnnotationMetadata().getAnnotation(RegistersProjectFeatures.class);
        registersProjectFeatures.ifPresent(registration -> this.addFeatureDeclarations(registration.value(), (Class)Cast.uncheckedCast((Object)typeMetadata.getType()), pluginId));
    }

    private void addFeatureDeclarations(Class<? extends Plugin<Project>>[] featurePlugins, Class<? extends Plugin<Settings>> registeringPlugin, @Nullable String pluginId) {
        for (Class<? extends Plugin<Project>> projectFeatureImplClass : featurePlugins) {
            this.validateProjectFeatures(projectFeatureImplClass, registeringPlugin);
            this.projectFeatureDeclarations.addDeclaration(pluginId, projectFeatureImplClass, registeringPlugin);
        }
    }

    void validateProjectFeatures(Class<? extends Plugin<Project>> projectTypePluginImplClass, Class<?> registeringPlugin) {
        boolean isBinding;
        DefaultTypeValidationContext typeValidationContext = DefaultTypeValidationContext.withRootType(projectTypePluginImplClass, (boolean)false, (InternalProblems)this.problems);
        TypeToken projectTypePluginImplType = TypeToken.of(projectTypePluginImplClass);
        TypeMetadata projectTypePluginImplMetadata = this.inspectionScheme.getMetadataStore().getTypeMetadata(projectTypePluginImplType.getRawType());
        projectTypePluginImplMetadata.visitValidationFailures(null, (TypeValidationContext)typeValidationContext);
        boolean bl = isBinding = projectTypePluginImplMetadata.getTypeAnnotationMetadata().getAnnotation(BindsProjectType.class).isPresent() || projectTypePluginImplMetadata.getTypeAnnotationMetadata().getAnnotation(BindsProjectFeature.class).isPresent();
        if (!isBinding) {
            typeValidationContext.visitTypeProblem(problem -> problem.withAnnotationType(projectTypePluginImplClass).id("missing-software-type", "Missing project feature annotation", GradleCoreProblemGroup.validation().type()).contextualLabel("is registered as a project feature plugin but does not expose a project feature").severity(Severity.ERROR).details("This class was registered as a project feature plugin, but it does not expose a project feature. Project feature plugins must expose at least one project feature via either a @BindsProjectType or @BindsProjectFeature annotation on the plugin class.").solution("Remove " + projectTypePluginImplClass.getSimpleName() + " from the @RegistersSoftwareTypes or @RegistersProjectFeatures annotation on " + registeringPlugin.getSimpleName()));
        }
        if (!typeValidationContext.getProblems().isEmpty()) {
            throw new DefaultMultiCauseException(String.format(typeValidationContext.getProblems().size() == 1 ? "A problem was found with the %s plugin." : "Some problems were found with the %s plugin.", projectTypePluginImplClass.getSimpleName()), (Iterable)typeValidationContext.getProblems().stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).sorted().map(InvalidUserDataException::new).collect(ImmutableList.toImmutableList()));
        }
    }
}

