/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.MessageBuilderHelper;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.jspecify.annotations.Nullable;

public final class SelectionReasonAssessor {
    private SelectionReasonAssessor() {
    }

    public static AssessedSelection assessSelection(ModuleResolveState moduleResolveState) {
        Set<? extends DependencyGraphEdge> allIncomingEdges = moduleResolveState.getAllIncomingEdges();
        ImmutableList.Builder assessedReasons = ImmutableList.builderWithExpectedSize((int)allIncomingEdges.size());
        for (DependencyGraphEdge dependencyGraphEdge : allIncomingEdges) {
            String requestedVersion = SelectionReasonAssessor.getRequestedVersion(dependencyGraphEdge.getDependencyMetadata().getSelector());
            ImmutableList<ImmutableList<String>> pathNames = MessageBuilderHelper.findPathNamesTo(dependencyGraphEdge);
            ImmutableSet<ComponentSelectionCause> causes = SelectionReasonAssessor.getCauses(dependencyGraphEdge);
            assessedReasons.add((Object)new AssessedSelection.AssessedSelectionReason(pathNames, requestedVersion, causes, dependencyGraphEdge.isFromLock()));
        }
        return new AssessedSelection(moduleResolveState.getId(), (ImmutableList<AssessedSelection.AssessedSelectionReason>)assessedReasons.build());
    }

    private static ImmutableSet<ComponentSelectionCause> getCauses(DependencyGraphEdge incomingEdge) {
        ImmutableSet.Builder causes = ImmutableSet.builder();
        incomingEdge.visitSelectionReasons(reason -> causes.add((Object)reason.getCause()));
        return causes.build();
    }

    private static @Nullable String getRequestedVersion(ComponentSelector selector) {
        VersionConstraint versionConstraint = SelectionReasonAssessor.getVersionConstraint(selector);
        if (versionConstraint != null) {
            return !versionConstraint.getStrictVersion().isEmpty() ? versionConstraint.getStrictVersion() : versionConstraint.getRequiredVersion();
        }
        return null;
    }

    private static @Nullable VersionConstraint getVersionConstraint(ComponentSelector selector) {
        if (selector instanceof ModuleComponentSelector) {
            return ((ModuleComponentSelector)selector).getVersionConstraint();
        }
        return null;
    }

    public static final class AssessedSelection {
        private final ModuleIdentifier moduleId;
        private final ImmutableList<AssessedSelectionReason> reasons;

        public AssessedSelection(ModuleIdentifier moduleId, ImmutableList<AssessedSelectionReason> reasons) {
            this.moduleId = moduleId;
            this.reasons = reasons;
        }

        public ModuleIdentifier getModuleId() {
            return this.moduleId;
        }

        public ImmutableList<AssessedSelectionReason> getReasons() {
            return this.reasons;
        }

        public static final class AssessedSelectionReason {
            private final ImmutableList<ImmutableList<String>> segmentedSelectionPaths;
            private final @Nullable String requestedVersion;
            private final ImmutableSet<ComponentSelectionCause> causes;
            private final boolean isFromLock;

            public AssessedSelectionReason(ImmutableList<ImmutableList<String>> segmentedSelectionPaths, @Nullable String requestedVersion, ImmutableSet<ComponentSelectionCause> causes, boolean isFromLock) {
                this.segmentedSelectionPaths = segmentedSelectionPaths;
                this.requestedVersion = requestedVersion;
                this.causes = causes;
                this.isFromLock = isFromLock;
            }

            public ImmutableList<ImmutableList<String>> getSegmentedSelectionPaths() {
                return this.segmentedSelectionPaths;
            }

            public @Nullable String getRequestedVersion() {
                return this.requestedVersion;
            }

            public Set<ComponentSelectionCause> getCauses() {
                return this.causes;
            }

            public boolean isFromLock() {
                return this.isFromLock;
            }
        }
    }
}

