/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import java.util.Collections;
import java.util.List;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailureFactory;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public class BuildCompletionNotifyingBuildActionRunner
implements BuildActionRunner {
    private final BuildOperationRunner buildOperationRunner;
    private final BuildActionRunner delegate;
    private final GradleEnterprisePluginManager gradleEnterprisePluginManager;
    private final FailureFactory failureFactory;

    public BuildCompletionNotifyingBuildActionRunner(GradleEnterprisePluginManager gradleEnterprisePluginManager, FailureFactory failureFactory, BuildOperationRunner buildOperationRunner, BuildActionRunner delegate) {
        this.gradleEnterprisePluginManager = gradleEnterprisePluginManager;
        this.failureFactory = failureFactory;
        this.buildOperationRunner = buildOperationRunner;
        this.delegate = delegate;
    }

    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        BuildActionRunner.Result result;
        try {
            result = this.delegate.run(action, buildController);
        }
        catch (Throwable t) {
            this.notifyEnterprisePluginManager(BuildActionRunner.Result.failed((Throwable)t, (Failure)this.failureFactory.create(t)));
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
        this.notifyEnterprisePluginManager(result);
        return result;
    }

    private void notifyEnterprisePluginManager(final BuildActionRunner.Result result) {
        assert (result.getBuildFailure() == null || result.getRichBuildFailure() != null) : "Rich build failure must not be null when build failure is present. Build failure: " + result.getBuildFailure();
        final List<Failure> unwrappedBuildFailure = BuildCompletionNotifyingBuildActionRunner.unwrapBuildFailure(result.getRichBuildFailure());
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                BuildCompletionNotifyingBuildActionRunner.this.gradleEnterprisePluginManager.buildFinished(result.getBuildFailure(), unwrappedBuildFailure);
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Develocity plugin build finished").details((Object)DevelocityPluginBuildFinishedBuildOperationType.DETAILS);
            }
        });
    }

    private static @Nullable List<Failure> unwrapBuildFailure(@Nullable Failure richBuildFailure) {
        if (richBuildFailure == null) {
            return null;
        }
        return richBuildFailure.getOriginal() instanceof MultipleBuildFailures ? richBuildFailure.getCauses() : Collections.singletonList(richBuildFailure);
    }

    @NullMarked
    public static interface DevelocityPluginBuildFinishedBuildOperationType
    extends BuildOperationType<Details, Result> {
        public static final Details DETAILS = new Details(){};

        public static interface Details {
        }

        public static interface Result {
        }
    }
}

