/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.CapabilitySerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;

@NotThreadSafe
public class ResolvedVariantResultSerializer
implements Serializer<ResolvedVariantResult> {
    private final Map<ResolvedVariantResult, Integer> written = new HashMap<ResolvedVariantResult, Integer>();
    private final List<ResolvedVariantResult> read = new ArrayList<ResolvedVariantResult>();
    private final ComponentIdentifierSerializer componentIdentifierSerializer;
    private final AttributeContainerSerializer attributeContainerSerializer;
    private final ListSerializer<Capability> capabilitySerializer;

    public ResolvedVariantResultSerializer(ComponentIdentifierSerializer componentIdentifierSerializer, AttributeContainerSerializer attributeContainerSerializer) {
        this.componentIdentifierSerializer = componentIdentifierSerializer;
        this.attributeContainerSerializer = attributeContainerSerializer;
        this.capabilitySerializer = new ListSerializer((Serializer)new CapabilitySerializer());
    }

    public ResolvedVariantResult read(Decoder decoder) throws Exception {
        int index = decoder.readSmallInt();
        if (index == -1) {
            return null;
        }
        if (index == this.read.size()) {
            ComponentIdentifier owner = this.componentIdentifierSerializer.read(decoder);
            String variantName = decoder.readString();
            ImmutableAttributes attributes = this.attributeContainerSerializer.read(decoder);
            ImmutableList capabilities = this.capabilitySerializer.read(decoder);
            this.read.add(null);
            ResolvedVariantResult externalVariant = this.read(decoder);
            DefaultResolvedVariantResult result = new DefaultResolvedVariantResult(owner, Describables.of((Object)variantName), (AttributeContainer)attributes, (ImmutableList<Capability>)capabilities, externalVariant);
            this.read.set(index, result);
            return result;
        }
        return this.read.get(index);
    }

    public void write(Encoder encoder, ResolvedVariantResult variant) throws Exception {
        if (variant == null) {
            encoder.writeSmallInt(-1);
            return;
        }
        Integer index = this.written.get(variant);
        if (index == null) {
            index = this.written.size();
            this.written.put(variant, index);
            encoder.writeSmallInt(index.intValue());
            this.componentIdentifierSerializer.write(encoder, variant.getOwner());
            encoder.writeString((CharSequence)variant.getDisplayName());
            this.attributeContainerSerializer.write(encoder, variant.getAttributes());
            this.capabilitySerializer.write(encoder, variant.getCapabilities());
            this.write(encoder, (ResolvedVariantResult)variant.getExternalVariant().orElse(null));
        } else {
            encoder.writeSmallInt(index.intValue());
        }
    }

    void reset() {
        this.written.clear();
        this.read.clear();
    }
}

