/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Consumer;
import org.gradle.internal.collect.ArrayCopy;
import org.gradle.internal.collect.ArrayIterator;
import org.gradle.internal.collect.PersistentArray;
import org.gradle.internal.collect.PersistentArrayTrie;
import org.gradle.internal.collect.ToString;
import org.gradle.util.internal.ArrayUtils;

final class PersistentArraySmall<T>
implements PersistentArray<T> {
    private final Object[] array;

    public PersistentArraySmall(Object[] array) {
        assert (array.length > 1 && array.length <= 32);
        this.array = array;
    }

    @Override
    public PersistentArray<T> plus(T value) {
        return this.array.length < 32 ? new PersistentArraySmall<T>(ArrayCopy.append(this.array, value)) : new PersistentArrayTrie(33, 0, this.array, new Object[]{value});
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public T get(int index) {
        return (T)this.array[index];
    }

    @Override
    public PersistentArray<T> set(int index, T value) {
        if (index < 0 || index >= this.array.length) {
            throw PersistentArrayTrie.indexOutOfBounds(index);
        }
        return new PersistentArraySmall<T>(ArrayCopy.replaceAt(index, this.array, value));
    }

    @Override
    public T getLast() {
        return (T)this.array[this.array.length - 1];
    }

    @Override
    public boolean contains(T value) {
        return ArrayUtils.contains((Object[])this.array, value);
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator(this.array);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        for (Object o : this.array) {
            action.accept(o);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PersistentArraySmall) {
            PersistentArraySmall other = (PersistentArraySmall)obj;
            return Arrays.equals(this.array, other.array);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public String toString() {
        return ToString.nonEmptyIterator(this.iterator());
    }
}

