/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.types;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.gradle.api.internal.classpath.RuntimeApiInfo;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.types.InstrumentationTypeRegistry;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Global.class, Scope.UserHome.class})
public class GradleCoreInstrumentationTypeRegistry
implements InstrumentationTypeRegistry {
    private final StreamHasher streamHasher;
    private final RuntimeApiInfo runtimeApiInfo;
    private final Lazy<Map<String, Set<String>>> instrumentedSuperTypes;
    private final Lazy<Optional<HashCode>> instrumentedHashCode;
    private final Lazy<Optional<HashCode>> upgradedPropertiesHashCode;

    @Inject
    public GradleCoreInstrumentationTypeRegistry(StreamHasher streamHasher, RuntimeApiInfo runtimeApiInfo) {
        this.streamHasher = streamHasher;
        this.runtimeApiInfo = runtimeApiInfo;
        this.instrumentedSuperTypes = Lazy.locking().of(this::loadInstrumentedSuperTypes);
        this.instrumentedHashCode = Lazy.locking().of(this::loadInstrumentedSuperTypesHash);
        this.upgradedPropertiesHashCode = Lazy.locking().of(this::loadUpgradedPropertiesHash);
    }

    @Override
    public Set<String> getSuperTypes(String type) {
        return ((Map)this.instrumentedSuperTypes.get()).getOrDefault(type, Collections.emptySet());
    }

    @Override
    public boolean isEmpty() {
        return ((Map)this.instrumentedSuperTypes.get()).isEmpty();
    }

    public Optional<HashCode> getInstrumentedTypesHash() {
        return (Optional)this.instrumentedHashCode.get();
    }

    public Optional<HashCode> getUpgradedPropertiesHash() {
        return (Optional)this.upgradedPropertiesHashCode.get();
    }

    private Map<String, Set<String>> loadInstrumentedSuperTypes() {
        ImmutableMap immutableMap;
        block8: {
            InputStream stream = this.runtimeApiInfo.getInstrumentedSuperTypes().openStream();
            try {
                Properties properties = new Properties();
                properties.load(stream);
                ImmutableMap.Builder builder = ImmutableMap.builder();
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> builder.put((Object)((String)k), (Object)ImmutableSet.copyOf((Object[])v.toString().split(",")))));
                immutableMap = builder.build();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            stream.close();
        }
        return immutableMap;
    }

    private Optional<HashCode> loadInstrumentedSuperTypesHash() {
        return this.loadHashCodeFromResource(this.runtimeApiInfo.getInstrumentedSuperTypes());
    }

    private Optional<HashCode> loadUpgradedPropertiesHash() {
        return this.loadHashCodeFromResource(this.runtimeApiInfo.getUpgradedProperties());
    }

    private Optional<HashCode> loadHashCodeFromResource(URL resource) {
        Optional<HashCode> optional;
        block8: {
            InputStream stream = resource.openStream();
            try {
                optional = Optional.of(this.streamHasher.hash(stream));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            stream.close();
        }
        return optional;
    }
}

