/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.internal;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ScriptClassPathResolver;
import org.gradle.api.internal.initialization.StandaloneDomainObjectContext;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.internal.tasks.properties.InspectionSchemeFactory;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.features.internal.binding.DefaultModelDefaultsApplicator;
import org.gradle.features.internal.binding.DefaultProjectFeatureApplicator;
import org.gradle.features.internal.binding.DefaultProjectFeatureDeclarations;
import org.gradle.features.internal.binding.ModelDefaultsApplicator;
import org.gradle.features.internal.binding.ModelDefaultsHandler;
import org.gradle.features.internal.binding.ProjectFeatureApplicator;
import org.gradle.features.internal.binding.ProjectFeatureDeclarations;
import org.gradle.initialization.ClassLoaderScopeRegistry;
import org.gradle.internal.Factory;
import org.gradle.internal.build.BuildIncluder;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.properties.annotations.MissingPropertyAnnotationHandler;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.AbstractGradleModuleServices;
import org.gradle.plugin.internal.PluginScheme;
import org.gradle.plugin.management.PluginManagementSpec;
import org.gradle.plugin.management.internal.DefaultPluginHandler;
import org.gradle.plugin.management.internal.DefaultPluginManagementSpec;
import org.gradle.plugin.management.internal.DefaultPluginResolutionStrategy;
import org.gradle.plugin.management.internal.PluginHandler;
import org.gradle.plugin.management.internal.PluginResolutionStrategyInternal;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginRegistry;
import org.gradle.plugin.management.internal.autoapply.CompositeAutoAppliedPluginRegistry;
import org.gradle.plugin.management.internal.autoapply.InjectedAutoAppliedPluginRegistry;
import org.gradle.plugin.use.internal.DefaultPluginRequestApplicator;
import org.gradle.plugin.use.internal.InjectedPluginClasspath;
import org.gradle.plugin.use.internal.PluginDependencyResolutionServices;
import org.gradle.plugin.use.internal.PluginRepositoryHandlerProvider;
import org.gradle.plugin.use.internal.PluginRequestApplicator;
import org.gradle.plugin.use.internal.PluginResolverFactory;
import org.gradle.plugin.use.resolve.service.internal.ClientInjectedClasspathPluginResolver;
import org.gradle.plugin.use.resolve.service.internal.DefaultInjectedClasspathPluginResolver;
import org.gradle.plugin.use.resolve.service.internal.InjectedClasspathInstrumentationStrategy;
import org.gradle.plugin.use.tracker.internal.PluginVersionTracker;
import org.jspecify.annotations.NullMarked;

public class PluginUseServices
extends AbstractGradleModuleServices {
    public void registerBuildServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new BuildScopeServices());
    }

    public void registerSettingsServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new SettingsScopeServices());
    }

    public void registerProjectServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new ProjectScopeServices());
    }

    private static class BuildScopeServices
    implements ServiceRegistrationProvider {
        private BuildScopeServices() {
        }

        @Provides
        void configure(ServiceRegistration registration) {
            registration.add(PluginResolverFactory.class);
            registration.add(PluginRequestApplicator.class, DefaultPluginRequestApplicator.class);
            registration.add(PluginVersionTracker.class);
        }

        @Provides
        void configure(ServiceRegistration registration, PluginScheme pluginScheme, InstantiatorFactory instantiatorFactory, InternalProblems problemsService) {
            DefaultProjectFeatureDeclarations projectFeatureRegistry = new DefaultProjectFeatureDeclarations(pluginScheme.getInspectionScheme(), (Instantiator)instantiatorFactory.injectScheme().instantiator(), problemsService.getInternalReporter());
            registration.add(ProjectFeatureDeclarations.class, (Object)projectFeatureRegistry);
        }

        @Provides
        AutoAppliedPluginRegistry createInjectedAutoAppliedPluginRegistry(BuildDefinition buildDefinition) {
            return new InjectedAutoAppliedPluginRegistry(buildDefinition);
        }

        @Provides
        PluginHandler createPluginHandler(List<AutoAppliedPluginRegistry> registries) {
            return new DefaultPluginHandler(new CompositeAutoAppliedPluginRegistry(registries));
        }

        @Provides
        PluginScheme createPluginScheme(InstantiatorFactory instantiatorFactory, InspectionSchemeFactory inspectionSchemeFactory) {
            InstantiationScheme instantiationScheme = instantiatorFactory.decorateScheme();
            ImmutableSet.Builder allPropertyTypes = ImmutableSet.builder();
            InspectionScheme inspectionScheme = inspectionSchemeFactory.inspectionScheme((Collection)allPropertyTypes.build(), Collections.emptySet(), Collections.emptyList(), instantiationScheme, MissingPropertyAnnotationHandler.DO_NOTHING);
            return new PluginScheme(instantiationScheme, inspectionScheme);
        }

        @Provides
        ClientInjectedClasspathPluginResolver createInjectedClassPathPluginResolver(DependencyManagementServices dependencyManagementServices, ClassLoaderScopeRegistry classLoaderScopeRegistry, PluginInspector pluginInspector, InjectedPluginClasspath injectedPluginClasspath, ScriptClassPathResolver scriptClassPathResolver, FileCollectionFactory fileCollectionFactory, InjectedClasspathInstrumentationStrategy instrumentationStrategy) {
            if (injectedPluginClasspath.getClasspath().isEmpty()) {
                return ClientInjectedClasspathPluginResolver.EMPTY;
            }
            Factory dependencyResolutionServicesFactory = () -> dependencyManagementServices.newDetachedResolver((DomainObjectContext)StandaloneDomainObjectContext.PLUGINS);
            return new DefaultInjectedClasspathPluginResolver(classLoaderScopeRegistry.getCoreAndPluginsScope(), scriptClassPathResolver, fileCollectionFactory, pluginInspector, injectedPluginClasspath.getClasspath(), instrumentationStrategy, (Factory<DependencyResolutionServices>)dependencyResolutionServicesFactory);
        }

        @Provides
        PluginResolutionStrategyInternal createPluginResolutionStrategy(Instantiator instantiator, ListenerManager listenerManager) {
            return (PluginResolutionStrategyInternal)instantiator.newInstance(DefaultPluginResolutionStrategy.class, new Object[]{listenerManager});
        }

        @Provides
        PluginDependencyResolutionServices createPluginDependencyResolutionServices(DependencyManagementServices dependencyManagementServices) {
            return new PluginDependencyResolutionServices((Factory<DependencyResolutionServices>)((Factory)() -> dependencyManagementServices.newDetachedResolver((DomainObjectContext)StandaloneDomainObjectContext.PLUGINS)));
        }
    }

    private static class SettingsScopeServices
    implements ServiceRegistrationProvider {
        private SettingsScopeServices() {
        }

        @Provides
        protected PluginManagementSpec createPluginManagementSpec(Instantiator instantiator, PluginRepositoryHandlerProvider pluginRepositoryHandlerProvider, PluginResolutionStrategyInternal internalPluginResolutionStrategy, FileResolver fileResolver, BuildIncluder buildIncluder) {
            return (PluginManagementSpec)instantiator.newInstance(DefaultPluginManagementSpec.class, new Object[]{pluginRepositoryHandlerProvider, internalPluginResolutionStrategy, fileResolver, buildIncluder});
        }
    }

    @NullMarked
    private static class ProjectScopeServices
    implements ServiceRegistrationProvider {
        private ProjectScopeServices() {
        }

        @Provides
        ProjectFeatureApplicator createProjectFeatureApplicator(InstantiatorFactory instantiatorFactory, ProjectInternal project, InternalProblems problems, ServiceRegistry services) {
            return (ProjectFeatureApplicator)instantiatorFactory.inject((ServiceLookup)services).newInstance(DefaultProjectFeatureApplicator.class, new Object[]{project.getClassLoaderScope(), project.getObjects(), problems.getInternalReporter(), services});
        }

        @Provides
        ModelDefaultsApplicator createModelDefaultsApplicator(List<ModelDefaultsHandler> modelDefaultsHandlers) {
            return new DefaultModelDefaultsApplicator(modelDefaultsHandlers);
        }
    }
}

