/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.features.internal.binding;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.model.ObjectFactoryFactory;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.features.binding.BuildModel;
import org.gradle.features.binding.Definition;
import org.gradle.features.binding.ProjectFeatureApplicationContext;
import org.gradle.features.file.ProjectFeatureLayout;
import org.gradle.features.internal.binding.ModelDefaultsApplicator;
import org.gradle.features.internal.binding.ProjectFeatureApplicationContextInternal;
import org.gradle.features.internal.binding.ProjectFeatureApplicator;
import org.gradle.features.internal.binding.ProjectFeatureBindingDeclaration;
import org.gradle.features.internal.binding.ProjectFeatureDeclarations;
import org.gradle.features.internal.binding.ProjectFeatureImplementation;
import org.gradle.features.internal.binding.ProjectFeatureSupportInternal;
import org.gradle.features.internal.file.DefaultProjectFeatureLayout;
import org.gradle.features.internal.registration.DefaultConfigurationRegistrar;
import org.gradle.features.internal.registration.DefaultTaskRegistrar;
import org.gradle.features.registration.ConfigurationRegistrar;
import org.gradle.features.registration.TaskRegistrar;
import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.instantiation.managed.ManagedObjectRegistry;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.UnknownServiceException;
import org.jspecify.annotations.Nullable;

public abstract class DefaultProjectFeatureApplicator
implements ProjectFeatureApplicator {
    private final ClassLoaderScope classLoaderScope;
    private final ObjectFactory projectObjectFactory;
    private final InternalProblemReporter problemReporter;
    private final ServiceLookup allServices;
    private static final Set<Class<?>> SAFE_APPLY_ACTION_SERVICES = ImmutableSet.of(TaskRegistrar.class, ProjectFeatureLayout.class, ConfigurationRegistrar.class, ObjectFactory.class, ProviderFactory.class, DependencyFactory.class, (Object[])new Class[0]);

    @Inject
    public DefaultProjectFeatureApplicator(ClassLoaderScope classLoaderScope, ObjectFactory projectObjectFactory, InternalProblemReporter problemReporter, ServiceLookup allServices) {
        this.classLoaderScope = classLoaderScope;
        this.projectObjectFactory = projectObjectFactory;
        this.problemReporter = problemReporter;
        this.allServices = allServices;
    }

    public <T extends Definition<V>, V extends BuildModel> T applyFeatureTo(DynamicObjectAware parentDefinition, ProjectFeatureImplementation<T, V> projectFeature) {
        ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext parentDefinitionContext = ProjectFeatureSupportInternal.getContext((DynamicObjectAware)parentDefinition);
        ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext.ChildDefinitionAdditionResult result = parentDefinitionContext.getOrAddChildDefinition(projectFeature, () -> {
            if (parentDefinition instanceof Project) {
                DefaultProjectFeatureApplicator.checkSingleProjectTypeApplication(parentDefinitionContext, projectFeature);
            }
            this.getPluginManager().apply(projectFeature.getPluginClass());
            Object definition = this.instantiateBoundFeatureObjectsAndApply(parentDefinition, projectFeature);
            return Cast.uncheckedNonnullCast(definition);
        });
        if (result.isNew) {
            Plugin plugin = this.getPluginManager().getPluginContainer().getPlugin(projectFeature.getPluginClass());
            this.getModelDefaultsApplicator().applyDefaultsTo((Object)parentDefinition, result.definition, (ModelDefaultsApplicator.ClassLoaderContext)new ClassLoaderContextFromScope(this.classLoaderScope), plugin, projectFeature);
        }
        return (T)((Definition)Cast.uncheckedNonnullCast((Object)result.definition));
    }

    private static <T extends Definition<V>, V extends BuildModel> void checkSingleProjectTypeApplication(ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext context, ProjectFeatureImplementation<T, V> projectFeature) {
        context.childrenDefinitions().keySet().stream().findFirst().ifPresent(projectTypeAlreadyApplied -> {
            throw new IllegalStateException("The project has already applied the '" + projectTypeAlreadyApplied.getFeatureName() + "' project type and is also attempting to apply the '" + projectFeature.getFeatureName() + "' project type.  Only one project type can be applied to a project.");
        });
    }

    private <T extends Definition<V>, V extends BuildModel> T instantiateBoundFeatureObjectsAndApply(Object parentDefinition, ProjectFeatureImplementation<T, V> projectFeature) {
        ServiceLookup featureServices = this.getContextSpecificServiceLookup(projectFeature);
        ObjectFactory featureObjectFactory = this.getObjectFactoryFactory().createObjectFactory(featureServices);
        T definition = this.instantiateDefinitionObject(featureObjectFactory, projectFeature);
        BuildModel buildModelInstance = ProjectFeatureSupportInternal.createBuildModelInstance((ObjectFactory)featureObjectFactory, projectFeature);
        ProjectFeatureSupportInternal.attachDefinitionContext(definition, (BuildModel)buildModelInstance, (ProjectFeatureApplicator)this, (ProjectFeatureDeclarations)this.getProjectFeatureDeclarations(), (ObjectFactory)featureObjectFactory);
        ProjectFeatureApplicationContext applyActionContext = (ProjectFeatureApplicationContext)this.projectObjectFactory.newInstance(DefaultProjectFeatureApplicationContextInternal.class, new Object[]{featureObjectFactory});
        projectFeature.getBindingTransform().transform(applyActionContext, definition, (Object)buildModelInstance, Cast.uncheckedCast((Object)parentDefinition));
        return definition;
    }

    private <T extends Definition<V>, V extends BuildModel> ServiceLookup getContextSpecificServiceLookup(ProjectFeatureImplementation<T, V> projectFeature) {
        DefaultTaskRegistrar taskRegistrar = new DefaultTaskRegistrar(this.getTaskContainer());
        DefaultProjectFeatureLayout projectFeatureLayout = new DefaultProjectFeatureLayout(this.getProjectLayout());
        DefaultConfigurationRegistrar configurationRegistrar = new DefaultConfigurationRegistrar(this.getConfigurationContainer());
        return projectFeature.getApplyActionSafety() == ProjectFeatureBindingDeclaration.Safety.SAFE ? new SafeServicesForApplyAction(this.allServices, (TaskRegistrar)taskRegistrar, (ProjectFeatureLayout)projectFeatureLayout, (ConfigurationRegistrar)configurationRegistrar, projectFeature.getFeatureName(), this.problemReporter) : new UnsafeServicesForApplyAction(this.allServices, (TaskRegistrar)taskRegistrar, (ProjectFeatureLayout)projectFeatureLayout, (ConfigurationRegistrar)configurationRegistrar, projectFeature.getFeatureName(), this.problemReporter);
    }

    private <T extends Definition<V>, V extends BuildModel> T instantiateDefinitionObject(ObjectFactory featureObjectFactory, ProjectFeatureImplementation<T, V> projectFeature) {
        return (T)((Definition)featureObjectFactory.newInstance(projectFeature.getDefinitionImplementationType(), new Object[0]));
    }

    @Inject
    protected abstract TaskContainer getTaskContainer();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract ConfigurationContainer getConfigurationContainer();

    @Inject
    protected abstract PluginManagerInternal getPluginManager();

    @Inject
    protected abstract ModelDefaultsApplicator getModelDefaultsApplicator();

    @Inject
    protected abstract ObjectFactoryFactory getObjectFactoryFactory();

    @Inject
    protected abstract ProjectFeatureDeclarations getProjectFeatureDeclarations();

    private static class ClassLoaderContextFromScope
    implements ModelDefaultsApplicator.ClassLoaderContext {
        private final ClassLoaderScope scope;

        public ClassLoaderContextFromScope(ClassLoaderScope scope) {
            this.scope = scope;
        }

        public ClassLoader getClassLoader() {
            return this.scope.getLocalClassLoader();
        }

        public ClassLoader getParentClassLoader() {
            return this.scope.getParent().getLocalClassLoader();
        }
    }

    static abstract class DefaultProjectFeatureApplicationContextInternal
    implements ProjectFeatureApplicationContextInternal {
        private final ObjectFactory objectFactory;

        @Inject
        public DefaultProjectFeatureApplicationContextInternal(ObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
        }

        public ObjectFactory getObjectFactory() {
            return this.objectFactory;
        }
    }

    private static class SafeServicesForApplyAction
    extends ServicesForApplyAction {
        private final String featureName;
        private final InternalProblemReporter problemReporter;

        public SafeServicesForApplyAction(ServiceLookup allServices, TaskRegistrar taskRegistrar, ProjectFeatureLayout projectFeatureLayout, ConfigurationRegistrar configurationRegistrar, String featureName, InternalProblemReporter problemReporter) {
            super(allServices, taskRegistrar, projectFeatureLayout, configurationRegistrar);
            this.featureName = featureName;
            this.problemReporter = problemReporter;
        }

        @Override
        public @Nullable Object find(Type serviceType) throws ServiceLookupException {
            Object found = super.find(serviceType);
            if (found != null) {
                return found;
            }
            Class serviceClass = (Class)Cast.uncheckedNonnullCast((Object)serviceType);
            for (Class safeService : SAFE_APPLY_ACTION_SERVICES) {
                if (!serviceClass.isAssignableFrom(safeService)) continue;
                return this.allServices.find(serviceType);
            }
            return null;
        }

        private static String getSafeServicesListExplanation() {
            TreeFormatter formatter = new TreeFormatter(true).node("Only the following services are available in safe apply actions");
            formatter.startChildren();
            for (Class safeService : SAFE_APPLY_ACTION_SERVICES) {
                formatter.node("").appendType((Type)safeService);
            }
            formatter.endChildren();
            return formatter.toString();
        }

        @Override
        protected Object notFound(Type serviceType) {
            InternalProblem problem = this.problemReporter.internalCreate(builder -> builder.id("safe-apply-action-uses-unsafe-service", "A safe apply action is attempting to use an unsafe service", GradleCoreProblemGroup.configurationUsage()).contextualLabel("Project feature '" + this.featureName + "' has a safe apply action that attempts to inject an unsafe service with type '" + serviceType.getTypeName() + "'.").details(SafeServicesForApplyAction.getSafeServicesListExplanation()).solution("Mark the apply action as unsafe.").solution("Remove the '" + serviceType.getTypeName() + "' injection from the apply action.").severity(Severity.ERROR));
            this.problemReporter.report((Problem)problem);
            throw new UnknownServiceException(serviceType, TypeValidationProblemRenderer.renderMinimalInformationAbout((InternalProblem)problem));
        }
    }

    private static class UnsafeServicesForApplyAction
    extends ServicesForApplyAction {
        private final String featureName;
        private final InternalProblemReporter problemReporter;

        public UnsafeServicesForApplyAction(ServiceLookup allServices, TaskRegistrar taskRegistrar, ProjectFeatureLayout projectFeatureLayout, ConfigurationRegistrar configurationRegistrar, String featureName, InternalProblemReporter problemReporter) {
            super(allServices, taskRegistrar, projectFeatureLayout, configurationRegistrar);
            this.featureName = featureName;
            this.problemReporter = problemReporter;
        }

        @Override
        public @Nullable Object find(Type serviceType) throws ServiceLookupException {
            Object found = super.find(serviceType);
            if (found != null) {
                return found;
            }
            return this.allServices.find(serviceType);
        }

        @Override
        protected Object notFound(Type serviceType) {
            InternalProblem problem = this.problemReporter.internalCreate(builder -> builder.id("unsafe-apply-action-uses-unknown-service", "An unsafe apply action is attempting to use an unknown service", GradleCoreProblemGroup.configurationUsage()).contextualLabel("Project feature '" + this.featureName + "' has an apply action that attempts to inject an unknown service with type '" + serviceType.getTypeName() + "'.").details("Services of type " + serviceType.getTypeName() + " are not available for injection into project feature apply actions.").solution("Remove the '" + serviceType.getTypeName() + "' injection from the apply action.").severity(Severity.ERROR));
            this.problemReporter.report((Problem)problem);
            throw new UnknownServiceException(serviceType, TypeValidationProblemRenderer.renderMinimalInformationAbout((InternalProblem)problem));
        }
    }

    private static abstract class ServicesForApplyAction
    implements ServiceLookup {
        protected final ServiceLookup allServices;
        protected final TaskRegistrar taskRegistrar;
        protected final ProjectFeatureLayout projectFeatureLayout;
        protected final ConfigurationRegistrar configurationRegistrar;

        private ServicesForApplyAction(ServiceLookup allServices, TaskRegistrar taskRegistrar, ProjectFeatureLayout projectFeatureLayout, ConfigurationRegistrar configurationRegistrar) {
            this.allServices = allServices;
            this.taskRegistrar = taskRegistrar;
            this.projectFeatureLayout = projectFeatureLayout;
            this.configurationRegistrar = configurationRegistrar;
        }

        public @Nullable Object find(Type serviceType) throws ServiceLookupException {
            if (serviceType instanceof Class) {
                Class serviceClass = (Class)Cast.uncheckedNonnullCast((Object)serviceType);
                if (serviceClass.isAssignableFrom(TaskRegistrar.class)) {
                    return this.taskRegistrar;
                }
                if (serviceClass.isAssignableFrom(ProjectFeatureLayout.class)) {
                    return this.projectFeatureLayout;
                }
                if (serviceClass.isAssignableFrom(ConfigurationRegistrar.class)) {
                    return this.configurationRegistrar;
                }
                if (serviceClass.isAssignableFrom(ManagedObjectRegistry.class)) {
                    return this.allServices.find(ManagedObjectRegistry.class);
                }
                if (serviceClass.isAssignableFrom(ProjectFeatureDeclarations.class)) {
                    return this.allServices.find(ProjectFeatureDeclarations.class);
                }
                if (serviceClass.isAssignableFrom(ProjectFeatureApplicator.class)) {
                    return this.allServices.find(ProjectFeatureApplicator.class);
                }
                if (serviceClass.isAssignableFrom(TaskDependencyFactory.class)) {
                    return this.allServices.find(TaskDependencyFactory.class);
                }
                if (serviceClass.isAssignableFrom(InstantiatorFactory.class)) {
                    return this.allServices.find(InstantiatorFactory.class);
                }
                return null;
            }
            return null;
        }

        public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
            Object result = this.find(serviceType);
            if (result == null) {
                return this.notFound(serviceType);
            }
            return result;
        }

        public Object get(Type serviceType, Class<? extends Annotation> annotatedWith) throws UnknownServiceException, ServiceLookupException {
            return this.notFound(serviceType);
        }

        protected abstract Object notFound(Type var1);
    }
}

