/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.features.internal.binding;

import java.util.Objects;
import java.util.Optional;
import org.gradle.features.binding.BuildModel;
import org.gradle.features.binding.DeclaredProjectFeatureBindingBuilder;
import org.gradle.features.binding.Definition;
import org.gradle.features.binding.ProjectFeatureApplyAction;
import org.gradle.features.binding.TargetTypeInformation;
import org.gradle.features.internal.binding.DeclaredProjectFeatureBindingBuilderInternal;
import org.gradle.features.internal.binding.ProjectFeatureBindingDeclaration;
import org.gradle.internal.Cast;
import org.gradle.util.Path;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DefaultDeclaredProjectFeatureBindingBuilder<T extends Definition<V>, V extends BuildModel>
implements DeclaredProjectFeatureBindingBuilderInternal<T, V> {
    private final Class<T> dslType;
    private final TargetTypeInformation<?> targetDefinitionType;
    private final Class<V> buildModelType;
    private final Path path;
    private final ProjectFeatureApplyAction<?, ?, ?> transform;
    private @Nullable Class<?> dslImplementationType;
    private @Nullable Class<?> buildModelImplementationType;
    private ProjectFeatureBindingDeclaration.Safety definitionSafety = ProjectFeatureBindingDeclaration.Safety.SAFE;
    private ProjectFeatureBindingDeclaration.Safety applyActionSafety = ProjectFeatureBindingDeclaration.Safety.SAFE;

    public DefaultDeclaredProjectFeatureBindingBuilder(Class<T> definitionType, Class<V> buildModelType, TargetTypeInformation<?> targetDefinitionType, Path path, ProjectFeatureApplyAction<T, V, ?> transform) {
        this.targetDefinitionType = targetDefinitionType;
        this.dslType = definitionType;
        this.buildModelType = buildModelType;
        this.path = path;
        this.transform = transform;
    }

    private static <T extends Definition<V>, V extends BuildModel> ProjectFeatureBindingDeclaration<T, V> bindingOf(final Class<T> definitionType, final @Nullable Class<? extends T> definitionImplementationType, final ProjectFeatureBindingDeclaration.Safety definitionSafety, final ProjectFeatureBindingDeclaration.Safety applyActionSafety, final Path path, final TargetTypeInformation<?> targetDefinitionType, final Class<V> buildModelType, final @Nullable Class<? extends V> buildModelImplementationType, final ProjectFeatureApplyAction<T, ?, V> transform) {
        return new ProjectFeatureBindingDeclaration<T, V>(){

            @Override
            public TargetTypeInformation<?> targetDefinitionType() {
                return targetDefinitionType;
            }

            @Override
            public Class<T> getDefinitionType() {
                return definitionType;
            }

            @Override
            public Optional<Class<? extends T>> getDefinitionImplementationType() {
                return Optional.ofNullable(definitionImplementationType);
            }

            @Override
            public ProjectFeatureBindingDeclaration.Safety getDefinitionSafety() {
                return definitionSafety;
            }

            @Override
            public ProjectFeatureBindingDeclaration.Safety getApplyActionSafety() {
                return applyActionSafety;
            }

            @Override
            public ProjectFeatureApplyAction<T, ?, V> getTransform() {
                return transform;
            }

            @Override
            public Class<V> getBuildModelType() {
                return buildModelType;
            }

            @Override
            public Optional<Class<? extends V>> getBuildModelImplementationType() {
                return Optional.ofNullable(buildModelImplementationType);
            }

            @Override
            public String getName() {
                return Objects.requireNonNull(path.getName());
            }
        };
    }

    public DeclaredProjectFeatureBindingBuilder<T, V> withUnsafeDefinitionImplementationType(Class<? extends T> implementationType) {
        this.dslImplementationType = implementationType;
        return this.withUnsafeDefinition();
    }

    public DeclaredProjectFeatureBindingBuilder<T, V> withBuildModelImplementationType(Class<? extends V> implementationType) {
        this.buildModelImplementationType = implementationType;
        return this;
    }

    public DeclaredProjectFeatureBindingBuilder<T, V> withUnsafeDefinition() {
        this.definitionSafety = ProjectFeatureBindingDeclaration.Safety.UNSAFE;
        return this;
    }

    public DeclaredProjectFeatureBindingBuilder<T, V> withUnsafeApplyAction() {
        this.applyActionSafety = ProjectFeatureBindingDeclaration.Safety.UNSAFE;
        return this;
    }

    @Override
    public ProjectFeatureBindingDeclaration<T, V> build() {
        if (this.dslImplementationType != null && !this.dslType.isAssignableFrom(this.dslImplementationType)) {
            throw new IllegalArgumentException("Implementation type " + this.dslImplementationType + " is not a subtype of dsl type " + this.dslType);
        }
        if (this.buildModelImplementationType != null && !this.buildModelType.isAssignableFrom(this.buildModelImplementationType)) {
            throw new IllegalArgumentException("Implementation type " + this.buildModelImplementationType + " is not a subtype of build model type " + this.buildModelType);
        }
        return DefaultDeclaredProjectFeatureBindingBuilder.bindingOf(this.dslType, (Class)Cast.uncheckedCast(this.dslImplementationType), this.definitionSafety, this.applyActionSafety, this.path, this.targetDefinitionType, this.buildModelType, (Class)Cast.uncheckedCast(this.buildModelImplementationType), (ProjectFeatureApplyAction)Cast.uncheckedCast(this.transform));
    }
}

