/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.SortedMap;
import org.gradle.api.Describable;
import org.gradle.internal.Cast;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.history.changes.CachingChangeContainer;
import org.gradle.internal.execution.history.changes.ChangeContainer;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.ErrorHandlingChangeContainer;
import org.gradle.internal.execution.history.changes.ExecutionStateChangeDetector;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.ImplementationChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.history.changes.InputFileChanges;
import org.gradle.internal.execution.history.changes.InputValueChanges;
import org.gradle.internal.execution.history.changes.MessageCollectingChangeVisitor;
import org.gradle.internal.execution.history.changes.OutputFileChanges;
import org.gradle.internal.execution.history.changes.PreviousSuccessChanges;
import org.gradle.internal.execution.history.changes.PropertyChanges;
import org.gradle.internal.execution.history.changes.SummarizingChangeContainer;
import org.gradle.internal.execution.history.impl.OutputSnapshotUtil;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.impl.ClassImplementationSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class DefaultExecutionStateChangeDetector
implements ExecutionStateChangeDetector {
    @Override
    public ExecutionStateChanges detectChanges(Describable executable, PreviousExecutionState lastExecution, BeforeExecutionState thisExecution, IncrementalInputProperties incrementalInputProperties, boolean hasOverlappingOutputs) {
        PreviousSuccessChanges previousSuccessState = new PreviousSuccessChanges(lastExecution.isSuccessful());
        ClassImplementationSnapshot currentImplementation = (ClassImplementationSnapshot)Cast.uncheckedNonnullCast((Object)thisExecution.getImplementation());
        ClassImplementationSnapshot previousImplementation = (ClassImplementationSnapshot)Cast.uncheckedNonnullCast((Object)lastExecution.getImplementation());
        ImmutableList currentAdditionalImplementations = (ImmutableList)Cast.uncheckedNonnullCast(thisExecution.getAdditionalImplementations());
        ImplementationChanges implementationChanges = new ImplementationChanges(previousImplementation, lastExecution.getAdditionalImplementations(), currentImplementation, (ImmutableList<ImplementationSnapshot>)currentAdditionalImplementations, executable);
        PropertyChanges inputPropertyChanges = new PropertyChanges((ImmutableSortedSet<String>)lastExecution.getInputProperties().keySet(), (ImmutableSortedSet<String>)thisExecution.getInputProperties().keySet(), "Input", executable);
        InputValueChanges inputPropertyValueChanges = new InputValueChanges(lastExecution.getInputProperties(), thisExecution.getInputProperties(), executable);
        PropertyChanges inputFilePropertyChanges = new PropertyChanges((ImmutableSortedSet<String>)lastExecution.getInputFileProperties().keySet(), (ImmutableSortedSet<String>)thisExecution.getInputFileProperties().keySet(), "Input file", executable);
        InputFileChanges nonIncrementalInputFileChanges = incrementalInputProperties.nonIncrementalChanges(lastExecution.getInputFileProperties(), thisExecution.getInputFileProperties());
        PropertyChanges outputFilePropertyChanges = new PropertyChanges((ImmutableSortedSet<String>)lastExecution.getOutputFilesProducedByWork().keySet(), (ImmutableSortedSet<String>)thisExecution.getOutputFileLocationSnapshots().keySet(), "Output", executable);
        ImmutableSortedMap<String, FileSystemSnapshot> remainingPreviouslyProducedOutputs = hasOverlappingOutputs ? OutputSnapshotUtil.findOutputsStillPresentSincePreviousExecution(lastExecution.getOutputFilesProducedByWork(), thisExecution.getOutputFileLocationSnapshots()) : thisExecution.getOutputFileLocationSnapshots();
        OutputFileChanges outputFileChanges = new OutputFileChanges((SortedMap<String, FileSystemSnapshot>)lastExecution.getOutputFilesProducedByWork(), (SortedMap<String, FileSystemSnapshot>)remainingPreviouslyProducedOutputs);
        ChangeContainer rebuildTriggeringChanges = DefaultExecutionStateChangeDetector.errorHandling(executable, new SummarizingChangeContainer(previousSuccessState, implementationChanges, inputPropertyChanges, inputPropertyValueChanges, outputFilePropertyChanges, outputFileChanges, inputFilePropertyChanges, nonIncrementalInputFileChanges));
        ImmutableList<String> rebuildReasons = DefaultExecutionStateChangeDetector.collectChanges(rebuildTriggeringChanges);
        if (!rebuildReasons.isEmpty()) {
            return ExecutionStateChanges.nonIncremental(rebuildReasons, thisExecution, incrementalInputProperties);
        }
        InputFileChanges directIncrementalInputFileChanges = incrementalInputProperties.incrementalChanges(lastExecution.getInputFileProperties(), thisExecution.getInputFileProperties());
        InputFileChanges incrementalInputFileChanges = DefaultExecutionStateChangeDetector.errorHandling(executable, DefaultExecutionStateChangeDetector.caching(directIncrementalInputFileChanges));
        ImmutableList<String> incrementalInputFileChangeMessages = DefaultExecutionStateChangeDetector.collectChanges(incrementalInputFileChanges);
        return ExecutionStateChanges.incremental(incrementalInputFileChangeMessages, incrementalInputFileChanges, incrementalInputProperties);
    }

    private static ImmutableList<String> collectChanges(ChangeContainer changes) {
        MessageCollectingChangeVisitor visitor = new MessageCollectingChangeVisitor(3);
        changes.accept(visitor);
        return visitor.getMessages();
    }

    private static InputFileChanges caching(InputFileChanges wrapped) {
        CachingChangeContainer cachingChangeContainer = new CachingChangeContainer(3, wrapped);
        return new InputFileChangesWrapper(wrapped, cachingChangeContainer);
    }

    private static ChangeContainer errorHandling(Describable executable, ChangeContainer wrapped) {
        return new ErrorHandlingChangeContainer(executable, wrapped);
    }

    private static InputFileChanges errorHandling(Describable executable, InputFileChanges wrapped) {
        ErrorHandlingChangeContainer errorHandlingChangeContainer = new ErrorHandlingChangeContainer(executable, wrapped);
        return new InputFileChangesWrapper(wrapped, errorHandlingChangeContainer);
    }

    private static class InputFileChangesWrapper
    implements InputFileChanges {
        private final InputFileChanges inputFileChangesDelegate;
        private final ChangeContainer changeContainerDelegate;

        public InputFileChangesWrapper(InputFileChanges inputFileChangesDelegate, ChangeContainer changeContainerDelegate) {
            this.inputFileChangesDelegate = inputFileChangesDelegate;
            this.changeContainerDelegate = changeContainerDelegate;
        }

        @Override
        public boolean accept(String propertyName, ChangeVisitor visitor) {
            return this.inputFileChangesDelegate.accept(propertyName, visitor);
        }

        @Override
        public boolean accept(ChangeVisitor visitor) {
            return this.changeContainerDelegate.accept(visitor);
        }
    }
}

