/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import java.io.Serializable;
import javax.inject.Inject;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.TestSuiteName;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.internal.jacoco.DefaultJacocoCoverageReport;
import org.gradle.testing.base.TestingExtension;
import org.gradle.testing.jacoco.plugins.JacocoCoverageReport;

@Incubating
public abstract class JacocoReportAggregationPlugin
implements Plugin<Project> {
    public static final String JACOCO_AGGREGATION_CONFIGURATION_NAME = "jacocoAggregation";

    @Inject
    protected abstract JvmPluginServices getEcosystemUtilities();

    public void apply(Project project) {
        project.getPluginManager().apply("org.gradle.reporting-base");
        project.getPluginManager().apply("jvm-ecosystem");
        project.getPluginManager().apply("jacoco");
        ConfigurationContainer configurations = project.getConfigurations();
        NamedDomainObjectProvider jacocoAggregation = configurations.dependencyScope(JACOCO_AGGREGATION_CONFIGURATION_NAME, conf -> conf.setDescription("Collects project dependencies for purposes of JaCoCo coverage report aggregation"));
        NamedDomainObjectProvider codeCoverageResultsConf = configurations.resolvable("aggregateCodeCoverageReportResults", conf -> {
            conf.setDescription("Resolvable configuration used to gather files for the JaCoCo coverage report aggregation via ArtifactViews, not intended to be used directly");
            conf.extendsFrom(new Configuration[]{(Configuration)jacocoAggregation.get()});
            project.getPlugins().withType(JavaBasePlugin.class, plugin -> this.getEcosystemUtilities().configureAsRuntimeClasspath((HasConfigurableAttributes)conf));
        });
        Provider sourceDirectories = codeCoverageResultsConf.map(conf -> conf.getIncoming().artifactView(view -> {
            view.withVariantReselection();
            view.componentFilter(JacocoReportAggregationPlugin.projectComponent());
            this.getEcosystemUtilities().configureAsSources((HasConfigurableAttributes)view);
        }).getFiles());
        Provider classDirectories = codeCoverageResultsConf.map(conf -> conf.getIncoming().artifactView(view -> {
            view.componentFilter(JacocoReportAggregationPlugin.projectComponent());
            view.attributes(attributes -> attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)attributes.named(LibraryElements.class, "classes"))));
        }).getFiles());
        ReportingExtension reporting = (ReportingExtension)project.getExtensions().getByType(ReportingExtension.class);
        reporting.getReports().registerBinding(JacocoCoverageReport.class, DefaultJacocoCoverageReport.class);
        reporting.getReports().withType(JacocoCoverageReport.class).all(report -> report.getReportTask().configure(task -> {
            task.getSourceDirectories().from(new Object[]{sourceDirectories});
            task.getClassDirectories().from(new Object[]{classDirectories});
            Provider executionData = codeCoverageResultsConf.map(conf -> conf.getIncoming().artifactView(view -> {
                view.withVariantReselection();
                view.componentFilter(JacocoReportAggregationPlugin.projectComponent());
                view.attributes(attributes -> {
                    attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)attributes.named(Category.class, "verification")));
                    attributes.attributeProvider(TestSuiteName.TEST_SUITE_NAME_ATTRIBUTE, report.getTestSuiteName().map(tt -> (TestSuiteName)attributes.named(TestSuiteName.class, tt)));
                    attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, (Object)((VerificationType)attributes.named(VerificationType.class, "jacoco-coverage")));
                    attributes.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"binary");
                });
            }).getFiles());
            task.getExecutionData().from(new Object[]{executionData});
        }));
        project.getPlugins().withId("jvm-test-suite", plugin -> {
            jacocoAggregation.configure(conf -> conf.getDependencies().add((Object)project.getDependencyFactory().create(project)));
            TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
            ExtensiblePolymorphicDomainObjectContainer testSuites = testing.getSuites();
            testSuites.withType(JvmTestSuite.class).all(testSuite -> reporting.getReports().create(testSuite.getName() + "CodeCoverageReport", JacocoCoverageReport.class, report -> report.getTestSuiteName().convention((Object)testSuite.getName())));
        });
    }

    private static Spec<ComponentIdentifier> projectComponent() {
        return SerializableLambdas.spec((SerializableLambdas.SerializableSpec & Serializable)id -> id instanceof ProjectComponentIdentifier);
    }
}

