/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.provider.model.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.internal.problems.failure.Failure;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ToolingModelBuilderResultInternal {
    private final @Nullable Object model;
    private final List<Failure> failures;

    private ToolingModelBuilderResultInternal(@Nullable Object model, List<Failure> failures) {
        this.model = model;
        this.failures = failures;
    }

    public void throwFailureIfPresent() {
        if (this.failures.isEmpty()) {
            return;
        }
        Throwable firstOriginalException = this.failures.get(0).getOriginal();
        if (firstOriginalException instanceof RuntimeException) {
            throw (RuntimeException)firstOriginalException;
        }
        throw new RuntimeException(firstOriginalException);
    }

    public @Nullable Object getModel() {
        return this.model;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    public static ToolingModelBuilderResultInternal attachFailures(@Nullable Object model, List<Failure> additionalFailures) {
        if (model instanceof ToolingModelBuilderResultInternal) {
            ToolingModelBuilderResultInternal result = (ToolingModelBuilderResultInternal)model;
            ImmutableList merged = ImmutableList.builder().addAll(additionalFailures).addAll(result.getFailures()).build();
            return ToolingModelBuilderResultInternal.of(result.getModel(), (List<Failure>)merged);
        }
        return ToolingModelBuilderResultInternal.of(model, (List<Failure>)ImmutableList.copyOf(additionalFailures));
    }

    public static ToolingModelBuilderResultInternal of(@Nullable Object model) {
        return new ToolingModelBuilderResultInternal(model, (List<Failure>)ImmutableList.of());
    }

    public static ToolingModelBuilderResultInternal of(@Nullable Object model, List<Failure> failures) {
        return new ToolingModelBuilderResultInternal(model, (List<Failure>)ImmutableList.copyOf(failures));
    }

    public static ToolingModelBuilderResultInternal of(List<Failure> failures) {
        return new ToolingModelBuilderResultInternal(null, (List<Failure>)ImmutableList.copyOf(failures));
    }
}

