/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.daemon.CompilerParameters;
import org.gradle.api.internal.tasks.compile.daemon.CompilerWorkerExecutor;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.internal.UncheckedException;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.internal.util.MergeOptionsUtil;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;

public abstract class AbstractDaemonCompiler<T extends CompileSpec>
implements Compiler<T> {
    private final CompilerWorkerExecutor compilerWorkerExecutor;

    public AbstractDaemonCompiler(CompilerWorkerExecutor compilerWorkerExecutor) {
        this.compilerWorkerExecutor = compilerWorkerExecutor;
    }

    public WorkResult execute(T spec) {
        DefaultWorkResult result = this.compilerWorkerExecutor.execute(this.getCompilerParameters(spec), this.toDaemonForkOptions(spec), this.getAdditionalCompilerServices());
        if (result.isSuccess()) {
            return result;
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)result.getException());
    }

    protected abstract DaemonForkOptions toDaemonForkOptions(T var1);

    protected abstract CompilerParameters getCompilerParameters(T var1);

    protected abstract Set<Class<?>> getAdditionalCompilerServices();

    protected BaseForkOptions mergeForkOptions(BaseForkOptions left, BaseForkOptions right) {
        BaseForkOptions merged = new BaseForkOptions();
        merged.setMemoryInitialSize(MergeOptionsUtil.mergeHeapSize((String)left.getMemoryInitialSize(), (String)right.getMemoryInitialSize()));
        merged.setMemoryMaximumSize(MergeOptionsUtil.mergeHeapSize((String)left.getMemoryMaximumSize(), (String)right.getMemoryMaximumSize()));
        Set mergedJvmArgs = MergeOptionsUtil.normalized((Iterable)left.getJvmArgs());
        mergedJvmArgs.addAll(MergeOptionsUtil.normalized((Iterable)right.getJvmArgs()));
        merged.setJvmArgs((List)Lists.newArrayList((Iterable)mergedJvmArgs));
        return merged;
    }
}

