/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.Main;
import org.codehaus.groovy.util.ReleaseInfo;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.util.internal.DefaultGradleVersion;
import org.gradle.util.internal.KotlinDslVersion;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class VersionInfoRenderer {
    private VersionInfoRenderer() {
    }

    public static String render(String daemonJvm) {
        return VersionInfoRenderer.render(daemonJvm, null);
    }

    public static String renderWithLauncherJvm(String daemonJvm) {
        return VersionInfoRenderer.render(daemonJvm, Jvm.current().toString());
    }

    private static String render(String daemonJvm, String launcherJvm) {
        DefaultGradleVersion currentVersion = DefaultGradleVersion.current();
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println();
        out.println("------------------------------------------------------------");
        out.println("Gradle " + currentVersion.getVersion());
        out.println("------------------------------------------------------------");
        out.println();
        int maxKey = "Launcher JVM".length();
        VersionInfoRenderer.printAligned(out, "Build time", currentVersion.getBuildTimestamp(), maxKey);
        VersionInfoRenderer.printAligned(out, "Revision", currentVersion.getGitRevision(), maxKey);
        out.println();
        VersionInfoRenderer.printAligned(out, "Kotlin", KotlinDslVersion.current().getKotlinVersion(), maxKey);
        VersionInfoRenderer.printAligned(out, "Groovy", ReleaseInfo.getVersion(), maxKey);
        VersionInfoRenderer.printAligned(out, "Ant", Main.getAntVersion(), maxKey);
        if (launcherJvm != null) {
            VersionInfoRenderer.printAligned(out, "Launcher JVM", launcherJvm, maxKey);
        }
        VersionInfoRenderer.printAligned(out, "Daemon JVM", daemonJvm, maxKey);
        VersionInfoRenderer.printAligned(out, "OS", OperatingSystem.current().toString(), maxKey);
        out.println();
        out.flush();
        return sw.toString();
    }

    private static void printAligned(PrintWriter out, String key, String value, int maxKey) {
        out.print(key + ": ");
        for (int i = key.length(); i < maxKey + 1; ++i) {
            out.print(' ');
        }
        out.println(value);
    }
}

