/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal.antlr2;

import antlr.Tool;
import antlr.preprocessor.Hierarchy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.plugins.antlr.internal.antlr2.GrammarFileMetadata;
import org.gradle.api.plugins.antlr.internal.antlr2.XRef;
import org.gradle.internal.UncheckedException;
import org.jspecify.annotations.Nullable;

public class MetadataExtractor {
    public static XRef extractMetadata(Set<File> sources) {
        Hierarchy hierarchy = new Hierarchy(new Tool());
        for (File grammarFile : sources) {
            try {
                hierarchy.readGrammarFile(grammarFile.getPath());
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Received FileNotFoundException on already read file", e);
            }
        }
        XRef xref = new XRef(hierarchy);
        for (File grammarFile : sources) {
            xref.addGrammarFile(new GrammarFileMetadata(grammarFile, hierarchy.getFile(grammarFile.getPath()), MetadataExtractor.getPackageName(grammarFile)));
        }
        return xref;
    }

    private static @Nullable String getPackageName(File grammarFile) {
        try {
            return MetadataExtractor.getPackageName(new FileReader(grammarFile));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read antlr grammar file", e);
        }
    }

    static @Nullable String getPackageName(Reader reader) throws IOException {
        String grammarPackageName = null;
        try (BufferedReader in = new BufferedReader(reader);){
            String line;
            while ((line = in.readLine()) != null) {
                Pattern p;
                Matcher m;
                if ((line = line.trim()).startsWith("package") && line.endsWith(";")) {
                    grammarPackageName = line.substring(8, line.length() - 1);
                    continue;
                }
                if (!line.startsWith("header") || !(m = (p = Pattern.compile("header \\{\\s*package\\s+(.+);\\s+}")).matcher(line)).matches()) continue;
                grammarPackageName = m.group(1);
            }
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        return grammarPackageName;
    }
}

