/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.problems.failure;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.ProblemLocator;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.problems.failure.CompositeStackTraceClassifier;
import org.gradle.internal.problems.failure.DefaultFailure;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailureFactory;
import org.gradle.internal.problems.failure.InternalStackTraceClassifier;
import org.gradle.internal.problems.failure.StackTraceClassifier;
import org.gradle.internal.problems.failure.StackTraceRelevance;
import org.gradle.util.internal.CollectionUtils;
import org.jspecify.annotations.Nullable;

public class DefaultFailureFactory
implements FailureFactory {
    private final StackTraceClassifier stackTraceClassifier;

    public static DefaultFailureFactory withDefaultClassifier() {
        return new DefaultFailureFactory(new CompositeStackTraceClassifier(new InternalStackTraceClassifier(), StackTraceClassifier.USER_CODE));
    }

    public DefaultFailureFactory(StackTraceClassifier stackTraceClassifier) {
        this.stackTraceClassifier = stackTraceClassifier;
    }

    public Failure create(Throwable failure) {
        return new Job(this.stackTraceClassifier, ProblemLocator.EMPTY_LOCATOR).convert(failure);
    }

    public Failure create(Throwable failure, ProblemLocator problemLocator) {
        return new Job(this.stackTraceClassifier, problemLocator).convert(failure);
    }

    private static final class Job {
        private final StackTraceClassifier stackTraceClassifier;
        private final ProblemLocator problemLocator;
        private final Set<Throwable> seen;
        private final Function<Throwable, Failure> recursiveConverter = this::convertRecursively;

        private Job(StackTraceClassifier stackTraceClassifier, ProblemLocator problemLocator) {
            this(stackTraceClassifier, problemLocator, (Set<Throwable>)null);
        }

        private Job(StackTraceClassifier stackTraceClassifier, ProblemLocator problemLocator, @Nullable Set<Throwable> parentSeen) {
            this.stackTraceClassifier = stackTraceClassifier;
            this.problemLocator = problemLocator;
            this.seen = Collections.newSetFromMap(new IdentityHashMap());
            if (parentSeen != null) {
                this.seen.addAll(parentSeen);
            }
        }

        public Failure convert(Throwable failure) {
            return this.convertRecursively(failure);
        }

        private Failure convertRecursively(Throwable failure) {
            if (!this.seen.add(failure)) {
                Throwable replacement = new Throwable("[CIRCULAR REFERENCE: " + failure + "]");
                replacement.setStackTrace(failure.getStackTrace());
                failure = replacement;
            }
            ImmutableList stackTrace = ImmutableList.copyOf((Object[])failure.getStackTrace());
            List<StackTraceRelevance> relevances = Job.classify((List<StackTraceElement>)stackTrace, this.stackTraceClassifier);
            SuppressedAndCauses suppressedAndCauses = Job.getSuppressedAndCauses(failure);
            List<Failure> suppressed = this.convertSuppressed(suppressedAndCauses);
            List<Failure> causes = this.convertCauses(suppressedAndCauses);
            ImmutableList problems = ImmutableList.copyOf((Collection)this.problemLocator.findAll(failure));
            return new DefaultFailure(failure, (List<StackTraceElement>)stackTrace, relevances, suppressed, causes, (List<InternalProblem>)problems);
        }

        private static List<StackTraceRelevance> classify(List<StackTraceElement> stackTrace, StackTraceClassifier classifier) {
            ArrayList<StackTraceRelevance> relevance = new ArrayList<StackTraceRelevance>(stackTrace.size());
            for (StackTraceElement stackTraceElement : stackTrace) {
                StackTraceRelevance r = classifier.classify(stackTraceElement);
                if (r == null) {
                    throw new GradleException("Unable to classify stack trace element: " + stackTraceElement);
                }
                relevance.add(r);
            }
            return relevance;
        }

        private static SuppressedAndCauses getSuppressedAndCauses(Throwable failure) {
            Throwable[] suppressed = Job.getSuppressed(failure);
            List<Throwable> causes = Job.getCauses(failure);
            return new SuppressedAndCauses(suppressed, causes);
        }

        private static @Nullable Throwable[] getSuppressed(Throwable parent) {
            if (!JavaVersion.current().isJava7Compatible()) {
                return null;
            }
            return parent.getSuppressed();
        }

        private static List<Throwable> getCauses(Throwable parent) {
            ImmutableList.Builder causes = new ImmutableList.Builder();
            if (parent instanceof MultiCauseException) {
                causes.addAll((Iterable)((MultiCauseException)parent).getCauses());
            } else if (parent.getCause() != null) {
                causes.add((Object)parent.getCause());
            }
            return causes.build();
        }

        private List<Failure> convertSuppressed(SuppressedAndCauses suppressedAndCauses) {
            Object[] suppressed = suppressedAndCauses.suppressed;
            if (suppressed == null) {
                return Collections.emptyList();
            }
            return CollectionUtils.collect((Object[])suppressed, this.determineRecursiveConverter(suppressedAndCauses.childCount()));
        }

        private List<Failure> convertCauses(SuppressedAndCauses suppressedAndCauses) {
            List causes = suppressedAndCauses.causes;
            if (causes.isEmpty()) {
                return Collections.emptyList();
            }
            return CollectionUtils.collect((Iterable)causes, this.determineRecursiveConverter(suppressedAndCauses.childCount()));
        }

        private Function<Throwable, Failure> determineRecursiveConverter(int size) {
            if (size <= 1) {
                return this.recursiveConverter;
            }
            return this::multiChildTransformer;
        }

        private Failure multiChildTransformer(Throwable throwable) {
            return new Job(this.stackTraceClassifier, this.problemLocator, this.seen).convert(throwable);
        }

        private static class SuppressedAndCauses {
            private final Throwable[] suppressed;
            private final List<Throwable> causes;

            public SuppressedAndCauses(@Nullable Throwable[] suppressed, List<Throwable> causes) {
                this.causes = causes;
                this.suppressed = suppressed;
            }

            public int childCount() {
                return this.causes.size() + (this.suppressed != null ? this.suppressed.length : 0);
            }
        }
    }
}

