/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.buildinit.InsecureProtocolOption;
import org.gradle.buildinit.tasks.InitBuild;

public abstract class BuildInitPlugin
implements Plugin<Project> {
    private static final String COMMENTS_PROPERTY = "org.gradle.buildinit.comments";

    public void apply(Project project) {
        if (project.getParent() == null) {
            project.getTasks().register("init", InitBuild.class, initBuild -> {
                initBuild.setGroup("Build Setup");
                initBuild.setDescription("Initializes a new Gradle build.");
                ProjectInternal projectInternal = (ProjectInternal)project;
                ProjectInternal.DetachedResolver detachedResolver = projectInternal.newDetachedResolver();
                initBuild.getProjectLayoutRegistry().getBuildConverter().configureClasspath(detachedResolver, project.getObjects(), (JvmPluginServices)projectInternal.getServices().get(JvmPluginServices.class));
                initBuild.getUseDefaults().convention((Object)false);
                initBuild.getInsecureProtocol().convention((Object)InsecureProtocolOption.WARN);
                initBuild.getAllowFileOverwrite().convention((Object)false);
                initBuild.getComments().convention(BuildInitPlugin.getCommentsProperty(project).orElse((Object)true));
                initBuild.getProjectDirectory().convention(project.getLayout().getProjectDirectory());
            });
        }
    }

    private static Provider<Boolean> getCommentsProperty(Project project) {
        return project.getProviders().gradleProperty(COMMENTS_PROPERTY).map(SerializableLambdas.transformer(Boolean::parseBoolean));
    }
}

