/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.MavenRepositoryContentDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MavenVersionUtils;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.artifacts.repositories.DefaultRepositoryContentDescriptor;
import org.gradle.api.internal.artifacts.repositories.RepositoryContentDescriptorInternal;
import org.gradle.internal.Actions;

class DefaultMavenRepositoryContentDescriptor
extends DefaultRepositoryContentDescriptor
implements MavenRepositoryContentDescriptor {
    private boolean snapshots = true;
    private boolean releases = true;

    public DefaultMavenRepositoryContentDescriptor(Supplier<String> repositoryNameSupplier, VersionParser versionParser) {
        super(repositoryNameSupplier, versionParser);
    }

    public void releasesOnly() {
        this.snapshots = false;
        this.releases = true;
    }

    public void snapshotsOnly() {
        this.snapshots = true;
        this.releases = false;
    }

    @Override
    public Action<? super ArtifactResolutionDetails> toContentFilter() {
        Action<? super ArtifactResolutionDetails> filter = super.toContentFilter();
        if (!this.snapshots || !this.releases) {
            Action action = details -> {
                if (!details.isVersionListing()) {
                    String version = MavenVersionUtils.toEffectiveVersion(details.getComponentId().getVersion());
                    if (this.snapshots && !version.endsWith("-SNAPSHOT")) {
                        details.notFound();
                        return;
                    }
                    if (this.releases && version.endsWith("-SNAPSHOT")) {
                        details.notFound();
                    }
                }
            };
            if (filter == Actions.doNothing()) {
                return action;
            }
            return Actions.composite((Action[])new Action[]{filter, action});
        }
        return filter;
    }

    @Override
    public RepositoryContentDescriptorInternal asMutableCopy() {
        DefaultMavenRepositoryContentDescriptor copy = new DefaultMavenRepositoryContentDescriptor(this.getRepositoryNameSupplier(), this.getVersionParser());
        if (this.getIncludedConfigurations() != null) {
            copy.setIncludedConfigurations(Sets.newHashSet(this.getIncludedConfigurations()));
        }
        if (this.getExcludedConfigurations() != null) {
            copy.setExcludedConfigurations(Sets.newHashSet(this.getExcludedConfigurations()));
        }
        if (this.getIncludeSpecs() != null) {
            copy.setIncludeSpecs(Sets.newHashSet(this.getIncludeSpecs()));
        }
        if (this.getExcludeSpecs() != null) {
            copy.setExcludeSpecs(Sets.newHashSet(this.getExcludeSpecs()));
        }
        if (this.getRequiredAttributes() != null) {
            copy.setRequiredAttributes(Maps.newHashMap(this.getRequiredAttributes()));
        }
        copy.releases = this.releases;
        copy.snapshots = this.snapshots;
        return copy;
    }
}

