/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ComponentSelectionReasonSerializer
implements Serializer<ComponentSelectionReasonInternal> {
    private final ComponentSelectionDescriptorSerializer componentSelectionDescriptorSerializer;

    public ComponentSelectionReasonSerializer(ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory) {
        this.componentSelectionDescriptorSerializer = new ComponentSelectionDescriptorSerializer(componentSelectionDescriptorFactory);
    }

    public ComponentSelectionReasonInternal read(Decoder decoder) throws IOException {
        ImmutableList<ComponentSelectionDescriptorInternal> descriptions = this.readDescriptions(decoder);
        return new ComponentSelectionReasons.DefaultComponentSelectionReason(descriptions);
    }

    private ImmutableList<ComponentSelectionDescriptorInternal> readDescriptions(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            builder.add((Object)this.componentSelectionDescriptorSerializer.read(decoder));
        }
        return builder.build();
    }

    public void write(Encoder encoder, ComponentSelectionReasonInternal value) throws IOException {
        List<ComponentSelectionDescriptorInternal> descriptions = value.getDescriptions();
        encoder.writeSmallInt(descriptions.size());
        for (ComponentSelectionDescriptorInternal description : descriptions) {
            this.componentSelectionDescriptorSerializer.write(encoder, description);
        }
    }
}

