/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.authentication.Authentication;
import org.gradle.authentication.http.BasicAuthentication;
import org.gradle.authentication.http.DigestAuthentication;
import org.gradle.authentication.http.HttpHeaderAuthentication;
import org.gradle.internal.authentication.AllSchemesAuthentication;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.transfer.DefaultExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transport.http.DefaultHttpSettings;
import org.gradle.internal.resource.transport.http.HttpClient;
import org.gradle.internal.resource.transport.http.HttpClientFactory;
import org.gradle.internal.resource.transport.http.HttpResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpResourceLister;
import org.gradle.internal.resource.transport.http.HttpResourceUploader;
import org.gradle.internal.resource.transport.http.SslContextFactory;

public class HttpConnectorFactory
implements ResourceConnectorFactory {
    private static final Set<String> SUPPORTED_PROTOCOLS = ImmutableSet.of((Object)"http", (Object)"https");
    private static final Set<Class<? extends Authentication>> SUPPORTED_AUTHENTICATION = ImmutableSet.of(BasicAuthentication.class, DigestAuthentication.class, HttpHeaderAuthentication.class, AllSchemesAuthentication.class);
    private final SslContextFactory sslContextFactory;
    private final HttpClientFactory httpClientFactory;

    public HttpConnectorFactory(SslContextFactory sslContextFactory, HttpClientFactory httpClientFactory) {
        this.sslContextFactory = sslContextFactory;
        this.httpClientFactory = httpClientFactory;
    }

    public Set<String> getSupportedProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    public Set<Class<? extends Authentication>> getSupportedAuthentication() {
        return SUPPORTED_AUTHENTICATION;
    }

    public ExternalResourceConnector createResourceConnector(ResourceConnectorSpecification connectionDetails) {
        HttpClient client = this.httpClientFactory.createClient(DefaultHttpSettings.builder().withAuthenticationSettings(connectionDetails.getAuthentications()).withSslContextFactory(this.sslContextFactory).withRedirectVerifier(connectionDetails.getRedirectVerifier()).build());
        HttpResourceAccessor accessor = new HttpResourceAccessor(client);
        HttpResourceLister lister = new HttpResourceLister(accessor);
        HttpResourceUploader uploader = new HttpResourceUploader(client);
        return new DefaultExternalResourceConnector((ExternalResourceAccessor)accessor, (ExternalResourceLister)lister, (ExternalResourceUploader)uploader);
    }
}

