/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph;

import org.gradle.internal.logging.text.StyledTextOutput;

public class LegendRenderer {
    private final StyledTextOutput output;
    private boolean hasCyclicDependencies;
    private boolean hasUnresolvableConfigurations;
    private boolean hasConstraints;

    public LegendRenderer(StyledTextOutput output) {
        this.output = output;
    }

    public void printLegend() {
        if (this.hasConstraints) {
            this.output.println();
            this.output.withStyle(StyledTextOutput.Style.Info).text((Object)"(c) - A dependency constraint, not a dependency. The dependency affected by the constraint occurs elsewhere in the tree.");
        }
        if (this.hasCyclicDependencies) {
            this.output.println();
            this.output.withStyle(StyledTextOutput.Style.Info).println((Object)"(*) - Indicates repeated occurrences of a transitive dependency subtree. Gradle expands transitive dependency subtrees only once per project; repeat occurrences only display the root of the subtree, followed by this annotation.");
        }
        if (this.hasUnresolvableConfigurations) {
            this.output.println();
            this.output.withStyle(StyledTextOutput.Style.Info).println((Object)"(n) - A dependency or dependency configuration that cannot be resolved.");
        }
    }

    public void setHasUnresolvableConfigurations(boolean hasUnresolvableConfigurations) {
        this.hasUnresolvableConfigurations = hasUnresolvableConfigurations;
    }

    public void setHasCyclicDependencies(boolean hasCyclicDependencies) {
        this.hasCyclicDependencies = hasCyclicDependencies;
    }

    public void setHasConstraints(boolean hasConstraints) {
        this.hasConstraints = hasConstraints;
    }
}

