/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform.filters;

import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.jspecify.annotations.NullMarked;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.PostDiscoveryFilter;

@NullMarked
public final class ClassMethodNameFilter
implements PostDiscoveryFilter {
    private final TestSelectionMatcher matcher;

    public ClassMethodNameFilter(TestSelectionMatcher matcher) {
        this.matcher = matcher;
    }

    public FilterResult apply(TestDescriptor descriptor) {
        if (this.classMatch(descriptor)) {
            return FilterResult.included((String)"Class match");
        }
        return FilterResult.includedIf((boolean)this.shouldRun(descriptor), () -> "Method or class match", () -> "Method or class mismatch");
    }

    private boolean shouldRun(TestDescriptor descriptor) {
        return this.shouldRun(descriptor, false);
    }

    private boolean shouldRun(TestDescriptor descriptor, boolean checkingParent) {
        Optional source = descriptor.getSource();
        if (!source.isPresent()) {
            return true;
        }
        TestSource testSource = (TestSource)source.get();
        if (testSource instanceof MethodSource) {
            return this.shouldRun(descriptor, (MethodSource)testSource);
        }
        if (testSource instanceof ClassSource) {
            return this.shouldRun(descriptor, checkingParent, (ClassSource)testSource);
        }
        Optional parent = descriptor.getParent();
        return parent.isPresent() && this.shouldRun((TestDescriptor)parent.get(), true);
    }

    private boolean shouldRun(TestDescriptor descriptor, boolean checkingParent, ClassSource classSource) {
        Set children = descriptor.getChildren();
        if (!checkingParent) {
            for (TestDescriptor child : children) {
                if (!this.shouldRun(child)) continue;
                return true;
            }
        }
        if (children.isEmpty()) {
            String className = classSource.getClassName();
            return this.matcher.matchesTest(className, null) || this.matcher.matchesTest(className, descriptor.getLegacyReportingName());
        }
        return true;
    }

    private boolean shouldRun(TestDescriptor descriptor, MethodSource methodSource) {
        String methodName = methodSource.getMethodName();
        return this.matcher.matchesTest(methodSource.getClassName(), methodName) || this.matchesParentMethod(descriptor, methodName);
    }

    private boolean matchesParentMethod(TestDescriptor descriptor, String methodName) {
        return descriptor.getParent().flatMap(this::className).filter(className -> this.matcher.matchesTest(className, methodName)).isPresent();
    }

    private boolean classMatch(TestDescriptor descriptor) {
        Optional parent;
        TestDescriptor current = descriptor;
        String methodName = null;
        while ((parent = current.getParent()).isPresent()) {
            Optional<String> className = this.className(current);
            if (className.isPresent() && this.matcher.matchesTest(className.get(), methodName)) {
                return true;
            }
            if (current.getSource().isPresent() && current.getSource().get() instanceof MethodSource) {
                methodName = ((MethodSource)current.getSource().get()).getMethodName();
            }
            current = (TestDescriptor)parent.get();
        }
        return false;
    }

    private Optional<String> className(TestDescriptor descriptor) {
        return descriptor.getSource().filter(ClassSource.class::isInstance).map(ClassSource.class::cast).map(ClassSource::getClassName);
    }
}

