/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ListSerializer<T>
extends AbstractSerializer<List<T>> {
    private final Serializer<T> entrySerializer;

    public ListSerializer(Serializer<T> entrySerializer) {
        this.entrySerializer = entrySerializer;
    }

    @Override
    public ImmutableList<T> read(Decoder decoder) throws Exception {
        int size = decoder.readInt();
        ImmutableList.Builder values = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            values.add(this.entrySerializer.read(decoder));
        }
        return values.build();
    }

    @Override
    public void write(Encoder encoder, List<T> value) throws Exception {
        encoder.writeInt(value.size());
        for (T t : value) {
            this.entrySerializer.write(encoder, t);
        }
    }
}

