/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryHelper;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.notations.DependencyNotationParser;
import org.gradle.api.internal.notations.ProjectDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.jspecify.annotations.Nullable;

public class DefaultDependencyFactory
implements DependencyFactoryInternal {
    private final Instantiator instantiator;
    private final DependencyNotationParser dependencyNotationParser;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final ObjectFactory objectFactory;
    private final ProjectDependencyFactory projectDependencyFactory;
    private final AttributesFactory attributesFactory;
    private final @Nullable Project project;

    public DefaultDependencyFactory(Instantiator instantiator, DependencyNotationParser dependencyNotationParser, NotationParser<Object, Capability> capabilityNotationParser, ObjectFactory objectFactory, ProjectDependencyFactory projectDependencyFactory, AttributesFactory attributesFactory, @Nullable Project project) {
        this.instantiator = instantiator;
        this.dependencyNotationParser = dependencyNotationParser;
        this.capabilityNotationParser = capabilityNotationParser;
        this.objectFactory = objectFactory;
        this.projectDependencyFactory = projectDependencyFactory;
        this.attributesFactory = attributesFactory;
        this.project = project;
    }

    public Dependency createDependency(Object dependencyNotation) {
        Dependency dependency = dependencyNotation instanceof Dependency && !(dependencyNotation instanceof MinimalExternalModuleDependency) ? (Dependency)dependencyNotation : (Dependency)this.dependencyNotationParser.getNotationParser().parseNotation(dependencyNotation);
        this.injectServices(dependency);
        return dependency;
    }

    private void injectServices(Dependency dependency) {
        if (dependency instanceof AbstractModuleDependency) {
            AbstractModuleDependency moduleDependency = (AbstractModuleDependency)dependency;
            moduleDependency.setAttributesFactory(this.attributesFactory);
            moduleDependency.setObjectFactory(this.objectFactory);
            moduleDependency.setCapabilityNotationParser(this.capabilityNotationParser);
        }
    }

    public ProjectDependency createProjectDependencyFromMap(ProjectFinder projectFinder, Map<? extends String, ? extends Object> map) {
        return this.projectDependencyFactory.createFromMap(projectFinder, map);
    }

    public ExternalModuleDependency create(CharSequence dependencyNotation) {
        ExternalModuleDependency dependency = (ExternalModuleDependency)this.dependencyNotationParser.getStringNotationParser().parseNotation((Object)dependencyNotation.toString());
        this.injectServices((Dependency)dependency);
        return dependency;
    }

    public ExternalModuleDependency create(@Nullable String group, String name, @Nullable String version) {
        return this.create(group, name, version, null, null);
    }

    public ExternalModuleDependency create(@Nullable String group, String name, @Nullable String version, @Nullable String classifier, @Nullable String extension) {
        DefaultExternalModuleDependency dependency = (DefaultExternalModuleDependency)((Object)this.instantiator.newInstance(DefaultExternalModuleDependency.class, new Object[]{group, name, version}));
        ModuleFactoryHelper.addExplicitArtifactsIfDefined((ExternalDependency)dependency, extension, classifier);
        this.injectServices((Dependency)dependency);
        return dependency;
    }

    public FileCollectionDependency create(FileCollection fileCollection) {
        return (FileCollectionDependency)this.dependencyNotationParser.getFileCollectionNotationParser().parseNotation((Object)fileCollection);
    }

    public ProjectDependency create(Project project) {
        ProjectDependency dependency = (ProjectDependency)this.dependencyNotationParser.getProjectNotationParser().parseNotation((Object)project);
        this.injectServices((Dependency)dependency);
        return dependency;
    }

    public ProjectDependency createProjectDependency(String projectPath) {
        if (this.project == null) {
            throw new IllegalStateException("This dependency factory is not associated with a project, so project dependencies cannot be created by path.  Use create(Project) instead.");
        }
        return this.create(this.project.project(projectPath));
    }

    public ProjectDependency createProjectDependency() {
        if (this.project == null) {
            throw new IllegalStateException("This dependency factory is not associated with a project, so a dependency for the current project cannot be created.  Use create(Project) instead.");
        }
        return this.create(this.project);
    }

    public Dependency gradleApi() {
        return this.createDependency(DependencyFactoryInternal.ClassPathNotation.GRADLE_API);
    }

    public Dependency gradleTestKit() {
        return this.createDependency(DependencyFactoryInternal.ClassPathNotation.GRADLE_TEST_KIT);
    }

    public Dependency localGroovy() {
        return this.createDependency(DependencyFactoryInternal.ClassPathNotation.LOCAL_GROOVY);
    }
}

