/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.artifacts.dsl;

import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.DependencyConstraintFactory;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.declarative.dsl.model.annotations.HiddenInDefinition;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.jspecify.annotations.Nullable;

public interface Dependencies {
    @Inject
    @HiddenInDefinition
    public DependencyFactory getDependencyFactory();

    @Inject
    @HiddenInDefinition
    public DependencyConstraintFactory getDependencyConstraintFactory();

    @Inject
    @Deprecated
    @HiddenInDefinition
    public Project getProject();

    default public ProjectDependency project(String projectPath) {
        return this.getDependencyFactory().createProjectDependency(projectPath);
    }

    @HiddenInDefinition
    default public ProjectDependency project() {
        return this.getDependencyFactory().createProjectDependency();
    }

    @HiddenInDefinition
    default public ExternalModuleDependency module(CharSequence dependencyNotation) {
        return this.getDependencyFactory().create(dependencyNotation);
    }

    @HiddenInDefinition
    @Deprecated
    default public ExternalModuleDependency module(@Nullable String group, String name, @Nullable String version) {
        String suggestedNotation = (group == null ? "" : group) + ":" + name + (version == null ? "" : ":" + version);
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)"Declaring dependencies using multi-string notation").withAdvice("Please use single-string notation instead: \"" + suggestedNotation + "\".")).willBecomeAnErrorInGradle10().withUpgradeGuideSection(9, "dependency_multi_string_notation")).nagUser();
        return this.getDependencyFactory().create(group, name, version);
    }

    @HiddenInDefinition
    default public DependencyConstraint constraint(CharSequence dependencyConstraintNotation) {
        return this.getDependencyConstraintFactory().create(dependencyConstraintNotation);
    }

    @Incubating
    @HiddenInDefinition
    default public Provider<? extends DependencyConstraint> constraint(Provider<? extends MinimalExternalModuleDependency> dependencyConstraint) {
        return dependencyConstraint.map(this.getDependencyConstraintFactory()::create);
    }

    @Incubating
    @HiddenInDefinition
    default public Provider<? extends DependencyConstraint> constraint(ProviderConvertible<? extends MinimalExternalModuleDependency> dependencyConstraint) {
        return this.constraint(dependencyConstraint.asProvider());
    }

    @HiddenInDefinition
    default public DependencyConstraint constraint(ProjectDependency project) {
        return this.getDependencyConstraintFactory().create(project);
    }

    @Inject
    @Deprecated
    @HiddenInDefinition
    public ObjectFactory getObjectFactory();
}

